/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "RPCFunction.h"

namespace mbed {

//Custom rpc method caller for execute so that the string will not be delimited by anything
void rpc_method_caller_run(RPC *this_ptr, Arguments *arguments, Reply *result) {
    ((static_cast<RPCFunction*>(this_ptr))->run)(arguments, result);
}

RPCFunction::RPCFunction(void (*f)(Arguments*, Reply*), const char* name) : RPC(name) {
    _ftr = f;
}

//Just run the attached function using the string thats in private memory - or just using null values, 
void RPCFunction::run(Arguments* args, Reply* r) {
    (*_ftr)(args, r);
}

const rpc_method *RPCFunction::get_rpc_methods() {
    static const rpc_method rpc_methods[] = {
        {"run", rpc_method_caller_run }, //Run using custom caller, all characters accepted in string
        RPC_METHOD_SUPER(RPC)
    };
    return rpc_methods;
}

}
