#include "MultiModalRobot.h"

MultiModalRobot::MultiModalRobot(Motor& left, Motor& right) : leftWheel(left), rightWheel(right), leftDir(0), rightDir(0) {}



void MultiModalRobot::driveWheels(float leftSpeed, float rightSpeed){
    if(leftSpeed*leftDir<0 || rightSpeed*rightDir<0){
     stop(0.5);
    }
    if(leftSpeed<0){
        leftDir = -1;
    } else {
        leftDir = 1;
    }
    if(rightSpeed<0){
        rightDir = -1;
    } else {
        rightDir = 1;
    }
    leftWheel.speed(leftSpeed);
    rightWheel.speed(rightSpeed);
    wait(0.1);
    stop(0.5);
}

void MultiModalRobot::stop(float dutyCycle){
    leftDir = rightDir = 0;
    leftWheel.coast();
    rightWheel.coast();
}
