#ifndef HALL_EFFECT_ENCODER_H
#define HALL_EFFECT_ENCODER_H

#include "mbed.h"

class HallEffectEncoder {
    
public:
    //CTOR
    HallEffectEncoder(PinName pin, float update_speed);
    
    //PUBLIC API
    float getDist();     // get the distance             //WIP has Wheel Diameter encoded
    float getSpeed();    // get the speed of the wheel
    int   getCount();    // get the count of the encoder
    
    void  reset();       // reset the count to 0

    
private:
    /* Encoder Input */
    InterruptIn _encoder;       // Input Pin
    void callback_transition(); // Pole transitions callback
    
    /* Speed Update Ticker */
    float ticker_update_speed;  // Update Period
    Ticker _speed_ticker;
    void  updateSpeed();        // Updates the speed of the wheel
    
    /* Internals */
    int   count; // Transitions count
    float speed; // Speed is in cm / s
    

    
};




#endif