#include "HallEffectEncoder.h"

//CTOR
HallEffectEncoder::HallEffectEncoder(PinName pin, float update_speed):
    _encoder(pin),
    ticker_update_speed(update_speed),
    count(0),
    speed(0)
{
    //Ecnoded Pullup resistor
    _encoder.mode(PullUp);
    
    // Set Poles Transitions callbacks
    _encoder.fall(this,&HallEffectEncoder::callback_transition);
    _encoder.rise(this,&HallEffectEncoder::callback_transition);
    
    //Set Speed update Ticker
    _speed_ticker.attach(this,&HallEffectEncoder::updateSpeed, ticker_update_speed);
    
}

// Encoder Input 
void HallEffectEncoder::callback_transition() {
    count++;
}

// Speed Update Ticker
void HallEffectEncoder::updateSpeed() {
    
    speed = (float)(getDist()) / (float)ticker_update_speed; // speed is in cm / s 
}




// Public API
float HallEffectEncoder::getDist() {
    // 384 counts ----> 20.42 cm
    float dist = ((float)(20.42) * (float)(getCount())) / (float)(384.0);
    reset();
    return dist;
}

float HallEffectEncoder::getSpeed() {
    // updateSpeed(); // JIT-update not so good
    return speed;
}

int HallEffectEncoder::getCount() {
    return count;
}

void HallEffectEncoder::reset() {
    count = 0;    
}


