#include "mbed.h"
#include "animations.h"

DigitalOut ledy0(PC_0);
DigitalOut ledy1(PC_1);
DigitalOut ledy2(PC_2);
DigitalOut ledx0(PC_13);
DigitalOut ledx1(PC_14);
DigitalOut ledx2(PC_15);

AnalogIn poti(A0);

void turnOn(short x, short y)
{
    switch(x) {
        case 0:
            ledx0 = 0;
            break;
        case 1:
            ledx1 = 0;
            break;
        case 2:
            ledx2 = 0;
            break;
    }

    switch(y) {
        case 0:
            ledy0 = 1;
            break;
        case 1:
            ledy1 = 1;
            break;
        case 2:
            ledy2 = 1;
            break;
    }
}

void turnOff(short x, short y)
{
    switch(x) {
        case 0:
            ledx0 = 1;
            break;
        case 1:
            ledx1 = 1;
            break;
        case 2:
            ledx2 = 1;
            break;
    }

    switch(y) {
        case 0:
            ledy0 = 0;
            break;
        case 1:
            ledy1 = 0;
            break;
        case 2:
            ledy2 = 0;
            break;
    }
}

void setPixel(int x, int y, bool on)
{
    if (on)
        turnOn(x,y);
    else
        turnOff(x,y);
}

int delay = 100;

void updateDelay()
{
    delay = 1000 + pow(poti * 4, 4) * 1000;
}

int leds[9][2] = {
    { 0, 0 },
    { 1, 0 },
    { 2, 0 },
    { 0, 1 },
    { 1, 1 },
    { 2, 1 },
    { 0, 2 },
    { 1, 2 },
    { 2, 2 },
};

void animate(int animation[][10] animation, int cycles, bool inverted = false)
{
    int frames = sizeof(animation) / 320;

    for (int frame = 0; frame < frames; frame++) {
        int frameTime = animation[frame][9];

        Timer timer;

        while (timer.read_ms() < frameTime) {
            for (int pixel = 0; pixel < 9; pixel++) {
                bool state = (bool)animation[frame][pixel] ^ inverted;
                setPixel(leds[pixel][0], leds[pixel][1], state);
                wait_us(delay);
                setPixel(leds[pixel][0], leds[pixel][1], !state);
            }
        }
    }
}

void init()
{
    for (int x = 0; x<3; x++)
        for (int y = 0; y<3; y++)
            turnOff(x,y);
}

int main()
{
    init();
    Ticker ticker;
    ticker.attach(&updateDelay, 0.05);

    while(true) {
        animate(animation1, 8);
        animate(animation2, 2);
        animate(animation3, 1);
        animate(animation4, 2);
        animate(animation5, 2);
        animate(transition6, 1);
        animate(animation6, 3);
        animate(end6, 1);
    }
}
