#include "mbed.h"
#include "rtos.h"
#include "main.h"
#include "ov7670.h"
 

 
 /*
  OV7670(
            PinName sda,    // Camera I2C port
            PinName scl,    // Camera I2C port
            PinName vs, l8 aa    // VS YNC
            PinName hr,     // HREF
            PinName we,     // WEN
                      
            PortName port,  // 8bit bus port
            int mask,       // 0b0000_0M65_4000_0321_L000_0000_0000_0000 = 0x07878000
            
            PinName rt,     // /RRST
            PinName o,      // /OE
            PinName rc      // RCLK      
            );
 
 
 */


                                         //D7-D0
 OV7670 camera(PTE0,PTE1,PTD6,PTD7,PTE31,PTC17,PTC16,PTC13,PTC12,PTC6,PTC5,PTC4,PTC3,PTB8,PTB9,PTB10); 









#define VGA     307200         //640*480
#define QVGA    76800          //320*240
#define QQVGA   19200          //160*120
 

static int resolution =QQVGA ;
//  char in[160][120]; 
 
I2C i2c(PTE0, PTE1);
 

 
int main() 
{  
    pc.baud(115200);       

    led4 = 0;






                     if(camera.Init('b', QQVGA) != 1)  // Set up for 160*120 pixels YUV (Only Y)
                    {
                      pc.printf("Init Fail\r\n");
                    }
                    pc.printf("Initializing done\r\n");


    
    wait_ms(50);
    
    //register
    int i = 0;
                    pc.printf("AD : +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F");
                    for (i=0;i<OV7670_REGMAX;i++) 
                    {
                        int data;
                        data = camera.ReadReg(i); // READ REG
                        if ((i & 0x0F) == 0) 
                        {
                            pc.printf("\r\n%02X : ",i);
                        }
                        pc.printf("%02X ",data);
                    }
                    pc.printf("\r\n");
   
    
    wait_ms(50);
    
    CameraSnap();
    
    
   
    
}
  
void CameraSnap()
{
        led4 = 1;
    //   pc.printf("++++++++++++++++++++++++++++++");
                // Kick things off by capturing an image
        camera.CaptureNext();
        while(camera.CaptureDone() == false);      
                // Start reading in the image data from the camera hardware buffer                   
        camera.ReadStart();  
      
        char max_in=0x00;
        char min_in=0xff;
      
   /*
         for(int x = 0; x<120; x++)
            for(int y=0;y <160;y++){
              camera.ReadOnebyte();
              
              in[x][y] = camera.ReadOnebyte();
         
             if (  max_in <in[x][y])
                     max_in = in[x][y];
             
       
             if(min_in > in[x][y])
                  min_in=in[x][y];
         
         }
        
        
     */   
     
       
        for(int x = 0; x<120; x++){
            for(int y=0;y <160;y++)
        {
             
                
           
                  
                     camera.ReadOnebyte();
                    // pc.printf("%1X " ,camera.ReadOnebyte());
            
               if( camera.ReadOnebyte()  > 0xe0 )
                        pc.printf("e");
               else if( camera.ReadOnebyte()  > 0xd0 )
                      pc.printf("d");    
                else if( camera.ReadOnebyte()  > 0xc0 )
                 pc.printf("c"); 
                 else if( camera.ReadOnebyte()  > 0xb0 )
                 pc.printf("b"); 
                  else if( camera.ReadOnebyte()  > 0xa0 )       
               pc.printf("a"); 
                   else if( camera.ReadOnebyte()  > 0x90 )
                    pc.printf("9"); 
                    else if( camera.ReadOnebyte()  > 0x80 )
                     pc.printf("8"); 
                     else if( camera.ReadOnebyte()  > 0x70 )
                      pc.printf("7"); 
                      else if( camera.ReadOnebyte()  > 0x60 )
                       pc.printf("6"); 
                       else if( camera.ReadOnebyte()  > 0x50 )
                        pc.printf("5"); 
                       
                        else if( camera.ReadOnebyte()  > 0x40 )
                         pc.printf("4"); 
                         else if( camera.ReadOnebyte()  > 0x30 )
                          pc.printf("3"); 
                          else if( camera.ReadOnebyte()  > 0x20 )
                      pc.printf("2"); 
                          else
                           pc.printf("1"); 
              
              
               //     if( (max_in-in[x][y]) > (in[x][y]-min_in) )
               //       pc.printf("X");
               //      else
               //       pc.printf(" ");     
                
                  
                
               
        }
        pc.printf("\r\n");
       }
        camera.ReadStop();
        camera.CaptureNext();
        while(camera.CaptureDone() == false);             
        
        pc.printf("\r\nSnap_done\r\n");   
        led4 = 0;
}



