#include "mbed.h"
#include "Servo.h"
#include "TSISensor.h"
#include "rtos.h"
DigitalOut ledR(LED1);
DigitalOut ledG(LED2);
DigitalOut ledB(LED3);

I2CSlave slave(PTE0,PTE1);
Servo s(PTB0); 



TSISensor tsi;


 bool strCmp(char*a, char*b){
     
     
     
     int ptr=0;
     bool flag=true;
     for(;a[ptr]!='\0'||b[ptr]!='\0';ptr++){
        if(a[ptr]!=b[ptr]){ 
         flag=false; 
         break;
        }
     }
     
     
     return flag;
     
}
 
 
void ledCtl(char* str){
 
    if(strCmp(str,"R")){
        ledR=0;
       
    }
    else if(strCmp(str,"G"))
        ledG=0;
    else if(strCmp(str,"B")) 
        ledB=0;
    else if(strCmp(str,"T"))
        ledR=1;
    else if(strCmp(str,"H"))
        ledG=1;
    else if(strCmp(str,"N"))
        ledB=1;
    else{
        ledR=ledG=ledB=1;    
        
    }
        
 } 


void servoCtl(char* str){
    float ang= (float) str[0];
    s.angle(ang);
        
        
 } 
 
 
 
void ble_i2c(void const *args) {
  
    char buf[20];
    char msg[] = "Backman!";
    slave.address(0xBA);
      
   
    while (true) {
        
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                 slave.write(msg, strlen(msg) + 1); // Includes null char
                 break;
            case I2CSlave::WriteGeneral:
                 slave.read(buf, 20);
                 printf("Read G: %s\n", buf);
                 break;
            case I2CSlave::WriteAddressed:
            
                 slave.read(buf, 20);    
                 //ledCtl(buf);
                 servoCtl(buf);
                 printf("Read A: %s\r\n", buf);
                 break;
        }
        for(int i = 0; i < 20; i++) buf[i] = 0;    // Clear buffer
        
        Thread::wait(50);
    }



} 
 
 
 
 
 
 
 
int main() {
    
    
    ledR=ledG=ledB=1;
   // Thread thread(ble_i2c);
    
    s.angle(0);
    
    char buf[20];
    char msg[] = "Backman!";
    slave.address(0xBA);
   
       
    while (true) {
        
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                 slave.write(msg, strlen(msg) + 1); // Includes null char
                 break;
            case I2CSlave::WriteGeneral:
                 slave.read(buf, 20);
                 printf("Read G: %s\n", buf);
                 break;
            case I2CSlave::WriteAddressed:
            
                 slave.read(buf, 20);    
                 //ledCtl(buf);
                 servoCtl(buf);
                 printf("Read A: %s\r\n", buf);
                 break;
        }
        for(int i = 0; i < 20; i++) buf[i] = 0;    // Clear buffer
        
       
    }
    
    
  
  
  return 0;
  
       
 }