#include "mbed.h"



class PID
{
public:
 
   
   float de_kp;
   float de_ip;
   float de_dp;
   
   
   
   float  de_output;
 
 
    /*
    * Constructeur
    * Sets default limits, calculates tuning parameters, and sets manual mode with no bias.
    * @param Kc - Tuning parameter
    * @param tauI - Tuning parameter
    * @param tauD - Tuning parameter
    * @param interval PID calculation performed every interval seconds.
    */
    PID(float in_min,float in_max,float out_min,float out_max,float Kc, float tauI, float tauD, float interval);
 
    /*
    * Scale from inputs to 0-100%.
    * @param InMin The real world value corresponding to 0%.
    * @param InMax The real world value corresponding to 100%.
    */
    void setInputLimits(float inMin, float inMax);
 
    /*
    * Scale from outputs to 0-100%.
    * @param outMin The real world value corresponding to 0%.
    * @param outMax The real world value corresponding to 100%.
    */
    void setOutputLimits(float outMin, float outMax);
 
    /*
    * Calculate PID constants.
    * Allows parameters to be changed on the fly without ruining calculations.
    * @param Kc - Tuning parameter
    * @param tauI - Tuning parameter
    * @param tauD - Tuning parameter
    */
    void setTunings(float Kc, float tauI, float tauD);
 
    /*
    * Reinitializes controller internals. Automatically
    * called on a manual to auto transition.
    */
 //   void reset(void);
 
    /*
    * Set how fast the PID loop is run.
    * @param interval PID calculation peformed every interval seconds.
    */
 //   void setInterval(float interval);
 
    /*
    * Set the bias.
    * @param bias The bias for the controller output.
    */
//    void setBias(float bias);
 
    /*
    * PID calculation.
    * @return The controller output as a float between outMin and outMax.
    */
    float compute(float pv, float sp);
 
    //Getters.
    float getInMin();
    float getInMax();
    float getOutMin();
    float getOutMax();
    float getInterval();
    float getPParam();
    float getIParam();
    float getDParam();
 
private:
    
  //  bool usingFeedForward;
 
    //Actual tuning parameters used in PID calculation.
    float Kc_;
    float tauI_;
    float tauD_;
    
    
    
     float pParam_;
    float iParam_;
    float dParam_;
    
    float accError_;
 
    //Raw tuning parameters.
   
    //The point we want to reach.
    float setPoint_;
    //The thing we measure.
    float processVariable_;
    float prevProcessVariable_;
    //The output that affects the process variable.
    float controllerOutput_;
    float prevControllerOutput_;
 
    //We work in % for calculations so these will scale from
    //real world values to 0-100% and back again.
    float inMin_;
    float inMax_;
    float inSpan_;
    
    float outMin_;
    float outMid_;
    float outMax_;
    float outSpan_;
 
    float ctrl_Lbound;
    float ctrl_Ubound;
 
 
 
 
    //The accumulated error, i.e. integral.
    //float accError_;
    //The controller output bias.
   // float bias_;
 
    //The interval between samples.
    float tSample_;
 
    //Controller output as a real world value.
   // volatile float realOutput_;
 
};
