#include "mbed.h"
#include "rtos.h"
#include "controller.h"
#include "servo_api.h"
#include "camera_api.h"
#include "motor_api.h"
#include "pot.h"
#include "TSISensor.h"

#define Debug_cam_uart
#define L_eye
//#define R_eye
#define motor_on 
#define Pcontroller
#define task_ma_time


#define R_target 20
#define L_target 108



#define t_cam 2




 Serial pc(USBTX, USBRX); // tx, rx



BX_servo servo; 

BX_camera cam(0);

BX_motor MotorA('A');
BX_motor MotorB('B');

BX_pot pot1('1');
BX_pot pot2('2');

                                 // 90/30=3
PID cam_to_M_ctrlr(10.0,118.0,0.046,0.083,0.083-0.046,0.00,0.00,10);

DigitalOut task_pin(PTD1);
TSISensor tsi;

//os
Mutex stdio_mutex; 






static int b_r_c=64;
static int b_l_c=64;
static int pre_b_r_c;

static double v_motor;
static double v_servo;





void cam_thread(void const *args){
    
    while(true){
     
           cam.read();
        
     
            b_r_c=cam.black_centerR();
            b_l_c=cam.black_centerL();
            //if(b_r_c==-1)
             //  b_r_c=pre_b_r_c;
            
            //pre_b_r_c=b_r_c;
            Thread::wait(t_cam);
        
        }
    
}
// function
void de_thread(void const *args){
    
    while(1){
        
        
        
        
    stdio_mutex.lock();    
    #ifdef Debug_cam_uart 
      #ifdef L_eye  
         pc.printf("L: ");
        for(int i=128;i>=0;i--){
             if(i==64)
               pc.printf("X");
             else if(i<10)
               pc.printf("-");
             else if(i>117)
               pc.printf("-");
             else          
               pc.printf("%c", cam.sign_line_imageL[i]);         
         }
         
         pc.printf("           ||             ");
      #endif
      #ifdef R_eye
        pc.printf("R: ");
        for(int i=128;i>=0;i--){
             if(i==64)
               pc.printf("X");
             else if(i<10)
               pc.printf("-");
             else if(i>117)
               pc.printf("-");
             else          
               pc.printf("%c", cam.sign_line_imageR[i]);         
         }
          #endif
         
         pc.printf("\r\n Rcenter :%d Lcenter : %d servo: %f \r\n",cam.black_centerR(),cam.black_centerL(),v_servo);
    
         
         stdio_mutex.unlock();
     
         
     
       
         
         
#endif   
             Thread::wait(1);

      
    }

}




void servo_thread(void const *args){
    

        while(1){
        
        if(b_r_c!=-1)
         v_servo=cam_to_M_ctrlr.compute(b_r_c,R_target);     
        if(b_l_c!=-1)
         v_servo=cam_to_M_ctrlr.compute(b_l_c,L_target);     
            
         
         
            

             // v_servo=pot2.read();
               servo.set_angle(v_servo);
              
         Thread::wait(20);    
        }    
    
    
    
}







void motor_thread(void const *args){
    
        while(1){
            
             v_motor=pot1.read();
             MotorA.rotate(v_motor);
             MotorB.rotate(v_motor);
            
            Thread::wait(10);    
        }
      
      
      
    
    }









int main() {
    
// baud rate init --- no function
  
    servo.set_angle(0.055);
    pc.baud(115200);
   /*
      while(1){
         
             if(tsi.readPercentage()>0.00011)
             break;
      }
    */
  
    
    
    
      Thread th_c(cam_thread);
   //   Thread thread(ctrl_thread);  
      Thread th_s(servo_thread);  
      Thread th_m(motor_thread);     
   //  Thread th_de(de_thread);  
     while(1){
         
           
     //idle
  //   stdio_mutex.lock();
    //    printf("L: %d  mid: %d R: %d\r\n",line3[0],line3[1],line3[2]);
    // stdio_mutex.unlock();     
         // Thread::wait(2000);
    
     }
   
     
     
    
    
    
    
    return 0;
    
    
}
