/*
 * mbed library for Stack
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file Stack.cpp
 * @brief Stack
 */

#include "Stack.h"

template <class T>
Stack<T>::Stack (int p_size) {
    size = p_size + 1;
    buf = new T[size];
//    buf = (T*)malloc(sizeof(T) * size);
    addr = 0;
}

template <class T>
Stack<T>::~Stack () {
    delete [] buf;
//    free(buf);
}

template <class T>
int Stack<T>::push (T dat) {

    if (addr >= size) {
        return -1;
    }
    buf[addr] = dat;
    addr ++;
    return dat;
}

template <class T>
int Stack<T>::pop (T *dat) {

    if (addr == 0) {
        return -1;
    }
    addr --;
    *dat = buf[addr];
    return 0;
}

template <class T>
int Stack<T>::read (T *dat) {

    if (addr == 0) {
        return -1;
    }
    *dat = buf[addr];
    return 0;
}

template <class T>
int Stack<T>::available () {
    return size - addr;
}

template <class T>
int Stack<T>::use () {
    return addr;
}

template <class T>
void Stack<T>::clear () {
    addr = 0;
}

template class Stack<int>;
template class Stack<float>;
