#include "mbed.h"
#include "rtos.h"
#include "controller.h"
#include "servo_api.h"
#include "camera_api.h"
#include "motor_api.h"
#include "pot.h"
#include "TSISensor.h"

#define Debug_cam_uart
#define L_eye
#define R_eye
#define motor_on 
#define Pcontroller
#define task_ma_time

#define t_cam 6









BX_servo servo; 

BX_camera cam;

BX_motor MotorA('A');
BX_motor MotorB('B');

BX_pot pot1('1');

                                 // 90/30=3
PID cam_to_M_ctrlr(10.0,118.0,0.059,0.105,0.105-0.059,0.00,0.02,10);

DigitalOut task_pin(PTD1);
TSISensor tsi;

//os
Mutex stdio_mutex; 


/*
void led2_thread(void const *args) {
   while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}
*/

static int b_r_c=0;
static int b_l_c=0;
static int line3[3]; //special point 
static int l3_p=0;

static double v_motor;
static double v_servo;

void cam_thread(void const *args){
    
    while(true){
        cam.read();
        
        b_l_c=(double)cam.black_centerL();
        
        if(l3_p==0){
        
            line3[l3_p]=(double)cam.black_centerR();
        }else if(l3_p==1){
            line3[l3_p]=0;
            
        }else {
           line3[l3_p]=(double)cam.black_centerL();    
               
        }        
               
        l3_p++;
        if(l3_p==3)
            l3_p=0;
            
        Thread::wait(t_cam);
        
        }
    
}
// function
void de_thread(void const *args){
    
    while(1){
        
        
          cam.read();
        
        b_l_c=(double)cam.black_centerL();
        
        if(l3_p==0){
        
            line3[l3_p]=(double)cam.black_centerR();
        }else if(l3_p==1){
            line3[l3_p]=0;
            
        }else {
           line3[l3_p]=(double)cam.black_centerL();    
               
        }        
               
        l3_p++;
        if(l3_p==3)
            l3_p=0;
        
        
    stdio_mutex.lock();    
    #ifdef Debug_cam_uart 
      #ifdef L_eye  
        printf("L: ");
        for(int i=0;i<128;i++){
             if(i==64)
               printf("X");
             else if(i<10)
               printf("-");
             else if(i>117)
              printf("-");  
               
             else          
               printf("%c", cam.sign_line_imageL[i]);
         }
         printf("           ||             ");
      #endif
      #ifdef R_eye
        printf("R: ");
        for(int i=128;i>=0;i--){
             if(i==64)
               printf("X");
             else if(i<10)
               printf("-");
             else if(i>117)
               printf("-");
             else          
               printf("%c", cam.sign_line_imageR[i]);         
         }
         printf("\r\n");
     #endif
         printf("L: %d  mid: %d R: %d\r\n",line3[0],line3[1],line3[2]);
         stdio_mutex.unlock();
     
         
     
       
         
         
#endif   
             Thread::wait(1);

      
    }

}




void servo_thread(void const *args){
    

        while(1){

             int ctrl=(line3[0]+line3[2])/2;
            
        
             v_servo=cam_to_M_ctrlr.compute(ctrl,118.0);
             servo.set_angle(v_servo);
            
         Thread::wait(20);    
        }    
    
    
    
}

void motor_thread(void const *args){
    
        while(1){
            
            
             MotorA.rotate(v_motor);
             MotorB.rotate(v_motor);
            
            Thread::wait(1);    
        }
      
      
      
    
    }


void ctrl_thread(void const *args){
    
    
    
      while(1){
          
         b_r_c=(double)cam.black_centerR();

         cam_to_M_ctrlr.compute(b_r_c,64.0);
          
          Thread::wait(1); 
      }    
    
    
    
    
}


// global resource








int main() {
    
// baud rate init --- no function
     
    
   /*
      while(1){
         
             if(tsi.readPercentage()>0.00011)
             break;
      }
    */
    //  Thread th_c(cam_thread);
   //   Thread thread(ctrl_thread);  
   //   Thread thread(servo_thread);  
   //   Thread thread(motor_thread);     
        Thread th_de(de_thread);  
     while(1){
         
           
     //idle
     //stdio_mutex.lock();
     //   printf("L: %d  mid: %d R: %d\r\n",line3[0],line3[1],line3[2]);
    // stdio_mutex.unlock();     
          Thread::wait(2000);
     
     }
   
     
     
    
    
    
    
    return 0;
    
    
}
