#include "mbed.h"
#include "rtos.h"
#include "controller.h"
#include "servo_api.h"
#include "camera_api.h"
#include "motor_api.h"
#include "pot.h"
#include "TSISensor.h"

#define Debug_cam_uart
#define L_eye
#define R_eye
#define motor_on 
#define Pcontroller
#define task_ma_time


#define car_center 15




#define t_cam 6




 Serial pc(USBTX, USBRX); // tx, rx



BX_servo servo; 

BX_camera cam(0);

BX_motor MotorA('A');
BX_motor MotorB('B');

BX_pot pot1('1');

                                 // 90/30=3
PID cam_to_M_ctrlr(10.0,118.0,0.059,0.105,0.105-0.059,0.00,0.02,10);

DigitalOut task_pin(PTD1);
TSISensor tsi;

//os
Mutex stdio_mutex; 





//static int line3[3]; //special point 

static int b_r_c=0;
static int b_l_c=118;

static int l3_p=0;

static double v_motor;
static double v_servo;

void cam_thread(void const *args){
    
    while(true){
     
        cam.read();
        
        
        b_r_c=cam.black_centerR();
      
          
            
        Thread::wait(t_cam);
        
        }
    
}
// function
void de_thread(void const *args){
    
    while(1){
        
        
        
        
    stdio_mutex.lock();    
    #ifdef Debug_cam_uart 
      #ifdef L_eye  
         pc.printf("R: ");
        for(int i=128;i>=0;i--){
             if(i==64)
               pc.printf("X");
             else if(i<10)
               pc.printf("-");
             else if(i>117)
               pc.printf("-");
             else          
               pc.printf("%c", cam.sign_line_imageL[i]);         
         }
         
         pc.printf("           ||             ");
      #endif
      #ifdef R_eye
        pc.printf("R: ");
        for(int i=128;i>=0;i--){
             if(i==64)
               pc.printf("X");
             else if(i<10)
               pc.printf("-");
             else if(i>117)
               pc.printf("-");
             else          
               pc.printf("%c", cam.sign_line_imageR[i]);         
         }
         pc.printf("\r\n");
     #endif
         pc.printf("L: %d  mid: %d R: %d  center: %d \r\n", );
         stdio_mutex.unlock();
     
         
     
       
         
         
#endif   
             Thread::wait(1);

      
    }

}




void servo_thread(void const *args){
    

        while(1){

            
        
         v_servo=cam_to_M_ctrlr.compute(b_r_c,car_center);
        
             servo.set_angle(v_servo);
            
         Thread::wait(20);    
        }    
    
    
    
}

void motor_thread(void const *args){
    
        while(1){
            
             v_motor=pot1.read();
             MotorA.rotate(v_motor);
             MotorB.rotate(v_motor);
            
            Thread::wait(10);    
        }
      
      
      
    
    }

/*
void ctrl_thread(void const *args){
    
    
    
      while(1){
          

         cam_to_M_ctrlr.compute(b_r_c,64.0);
          
          Thread::wait(1); 
      }    
    
    
    
    
}
*/

// global resource








int main() {
    
// baud rate init --- no function
  
    pc.baud(115200);
   /*
      while(1){
         
             if(tsi.readPercentage()>0.00011)
             break;
      }
    */
      Thread th_c(cam_thread);
   //   Thread thread(ctrl_thread);  
      Thread th_s(servo_thread);  
      Thread th_m(motor_thread);     
     //   Thread th_de(de_thread);  
     while(1){
         
           
     //idle
  //   stdio_mutex.lock();
    //    printf("L: %d  mid: %d R: %d\r\n",line3[0],line3[1],line3[2]);
    // stdio_mutex.unlock();     
         // Thread::wait(2000);
    
     }
   
     
     
    
    
    
    
    return 0;
    
    
}
