#include "mbed.h"
#include "camera_api.h"

#define clk 2  //ms

BX_camera::BX_camera(int p)
{

    line_CamR = new FastAnalogIn(PTD5);
    line_CamL=   new FastAnalogIn(PTD6,0);
    cam_clk=new DigitalOut(PTE1);
    si=new DigitalOut(PTD7);
    padding = p;
}

int BX_camera::black_centerR(void)
{

    int l_care=10;
    int r_care=118;


    // find center
    // case 1      //  |  //
    // case 2       /  |  /

    char find_type=0x00;

    int b_end=0;
    int b_start=0;

    int b_w=0;
    int b_center=0;

    int b2_end=0;
    int b2_start=0;
    int b2_center=0;

    int b2_w=0;

    int center=30;
    int j=64;
    bool f1=false;
    bool f2=false;
    bool f3=false;
    bool f4=false;
    int w_thr_up=32;
    int w_thr_dn=0;

    if(sign_line_imageR[64]==' ')
        find_type=0x02;
    else
        find_type=0x01;


    for(int i=64; i<r_care; i++,j--) {


        switch(find_type) {


            case 0x01:

                if(f1==false&&sign_line_imageR[i]==' ') {
                    if(f1==false) {
                        b_start=i;
                        f1=true;
                    }

                }
                if(f1== true&& f2==false&&sign_line_imageR[i]=='O') {
                    if(f2==false) {
                        b_end=i-1;
                        f2=true;
                    }

                }

                if(f3==false&&sign_line_imageR[j]==' ') {
                    if(f3==false) {
                        b2_end=j;
                        f3=true;
                    }

                }
                if(f3==true&&f4==false&&sign_line_imageR[j]=='O') {
                    if(f4==false) {
                        b2_start=j-1;
                        f4=true;
                    }

                }


                break;


            case 0x02:

                if(sign_line_imageR[i]=='O') {

                    if(f1==false) {
                        b_end=i;
                        f1=true;
                    }
                }

                if(sign_line_imageR[j]=='O') {

                    if(f2==false) {
                        b_start=j;
                        f2=true;
                    }

                }


                break;

        }


    }

    b_w=b_start-b_end;
    b2_w=b2_start-b2_end;
    
    de_v=b_start;
    de_v2=b_end;    

    switch(find_type) {

        case 0x01:
                b_center=(b_end+b_start)/2;
                b2_center=(b2_end+b2_start)/2;
                
                
                if(w_thr_up>b_w&&(b_center!=0)&&(b_center-64)<(64-b2_center))
                      center=b_center;                   
                else
                      center=b2_center;





/*            if( ( w_thr_up- (b_w))>0  &&( ( w_thr_up- (b_w)) < (w_thr_up-(b2_w)) )           ) {
                center=(b_end+b_start)/2;



  //          } else if( ( w_thr_up- (b2_w) )>0 ) {
                center=(b2_end+b2_start)/2;
//            } else {

                center=65;

                //????????????????

            }

*/
            break;

        case 0x02:
            center=(b_end+b_start)/2;


            break;
    }

    return center;
   
}



int BX_camera::black_centerL(void)
{

    int l_care=10;
    int r_care=118;


    // find center
    // case 1      //  |  //
    // case 2       /  |  /

    char find_type=0x00;

    int b_end=118;
    int b_start=118;

    int b_w=0;
    int b_center=0;

    int b2_end=0;
    int b2_start=0;
    int b2_center=0;

    int b2_w=0;

    int center=30;
    int j=64;
    bool f1=false;
    bool f2=false;
    bool f3=false;
    bool f4=false;
    int w_thr_up=32;
    int w_thr_dn=0;

    if(sign_line_imageR[64]==' ')
        find_type=0x02;
    else
        find_type=0x01;


    for(int i=64; i<r_care; i++,j--) {


        switch(find_type) {


            case 0x01:

                if(f1==false&&sign_line_imageL[i]==' ') {
                    if(f1==false) {
                        b_start=i;
                        f1=true;
                    }

                }
                if(f1== true&& f2==false&&sign_line_imageL[i]=='O') {
                    if(f2==false) {
                        b_end=i-1;
                        f2=true;
                    }

                }

                if(f3==false&&sign_line_imageL[j]==' ') {
                    if(f3==false) {
                        b2_end=j;
                        f3=true;
                    }

                }
                if(f3==true&&f4==false&&sign_line_imageL[j]=='O') {
                    if(f4==false) {
                        b2_start=j-1;
                        f4=true;
                    }

                }


                break;


            case 0x02:

                if(sign_line_imageL[i]=='O') {

                    if(f1==false) {
                        b_end=i;
                        f1=true;
                    }
                }

                if(sign_line_imageL[j]=='O') {

                    if(f2==false) {
                        b_start=j;
                        f2=true;
                    }

                }


                break;

        }


    }

    b_w=b_start-b_end;
    b2_w=b2_start-b2_end;
    
    de_v=b_start;
    de_v2=b_end;    

    switch(find_type) {

        case 0x01:
                b_center=(b_end+b_start)/2;
                b2_center=(b2_end+b2_start)/2;
                
                
                if(w_thr_up>b_w&&(b_center!=0)&&(b_center-64)<(64-b2_center))
                      center=b_center;                   
                else
                      center=b2_center;





/*            if( ( w_thr_up- (b_w))>0  &&( ( w_thr_up- (b_w)) < (w_thr_up-(b2_w)) )           ) {
                center=(b_end+b_start)/2;



  //          } else if( ( w_thr_up- (b2_w) )>0 ) {
                center=(b2_end+b2_start)/2;
//            } else {

                center=65;

                //????????????????

            }

*/
            break;

        case 0x02:
            center=(b_end+b_start)/2;


            break;
    }

    return (center+padding);
   
}





void BX_camera::read(void)
{

    w_f_vL=0x0000;
    b_f_vL=0xffff;

    w_f_vR=0x0000;
    b_f_vR=0xffff;




    *si=1;
    *cam_clk=1;

    wait_us(30);   // tune here
    *si=0;
    *cam_clk=0;



    line_CamR->enable();
    line_CamL->enable();


    //input 128 //both

    for(int i=0; i<128; i++) {
        *cam_clk=1;
        wait_us(5);


        line_imageR[i]=line_CamR->read_u16();
        line_imageL[i]=line_CamL->read_u16();

        //  big small
        if(line_imageR[i] > w_f_vR)
            w_f_vR=line_imageR[i];
        else if(line_imageR[i] < b_f_vR )
            b_f_vR = line_imageR[i];


        if(line_imageL[i] > w_f_vL)
            w_f_vL=line_imageL[i];
        else if(line_imageL[i] < b_f_vL )
            b_f_vL = line_imageL[i];




        *cam_clk=0;
        wait_us(5);


    }


    line_CamR->enable();
    line_CamL->enable();


    //filter L R   //may change

    for(int i=0; i<128; i++) {


        if( (line_imageR[i]-b_f_vR) < (w_f_vR - line_imageR[i] )    )
            sign_line_imageR[i]=' ';
        else
            sign_line_imageR[i]='O';


        if( (line_imageL[i]-b_f_vL) < (w_f_vL - line_imageL[i] )    )
            sign_line_imageL[i]=' ';
        else
            sign_line_imageL[i]='O';





        if(i==0) {
            sign_line_imageR[i]='X';
            sign_line_imageL[i]='X';
        }


    }



}