/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"
 
/*
 * Definisanje makroa:
 */
 #define BUZZ_PERIOD 7
 #define BUZZ_ON 1
 #define BUZZ_OFF 0
 #define BUZZ_DUTY_CYCLE 0.5
 #define PERIOD 0.1
 #define PERIOD_MS 12
 
 /*
 *  Instanciranje:
 */
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
PwmOut buzz(PA_11);
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
DigitalOut select1(PB_6);
DigitalOut select2(PC_7);
InterruptIn SW1(PC_9);

 
 /*
 * Globalne promenljive:
 */
 double pot1_val, pot2_val;
 double pot1_percent, pot2_percent;
 double dig1, dig2;

 
static int digits[] = { // G, F, E, D, C, B, A 
                          0xC0,  // NULA
                          0xF9,  // JEDAN
                          0xA4,  // DVA
                          0xB0,  // TRI
                          0x99,  // CETIRI
                          0x92,  // PET
                          0x82,  // SEST
                          0xF8,  // SEDAM
                          0x80,  // OSAM
                          0x90,  // DEVET
                          0xFF   // UGASI       
                         };
 
/*
 * Deklaracija funkcija:
 */
 void ISR_sw1(void);
 
/*
 * Glavna funkcija:
 */
int main(){
    
    // NAPOMENA: Radi sa ubodenim JP1
    static char ButtonPressed = 0;
    
    
    
    select1.write(1);
    select2.write(0);
    display.write(digits[10]);
    
    while(true){
        // Ocitavanje vrednosti potenciometara(0 - 1)
        pot1_val = pot1.read();
        pot2_val = pot2.read();
        
        // Promena frekvencije potenciometrom 2
        buzz.period((1.0/300) * pot2_val);
        
        //Promena jacine zvuka potenciometrom 1
        buzz.write(BUZZ_DUTY_CYCLE * pot1_val);        
        wait_ms(BUZZ_PERIOD);
        
        // Vrednosti potenciometara u procentima
        pot1_percent = pot1_val * 100.0;
        pot2_percent = pot2_val * 100.0;
        
        /* IDEJA KOJA NIJE HTELA DA RADI ZBOG dig1 i dig2 :(
        // Vrednosti cifara displeja
        dig1 = (int)(pot1_percent - (pot1_percent % 10.0)) / 10;
        dig2 = (int)pot1_percent % 10;
        
        // Pritisak dugmeta
        //sw1.fall(&ISR_sw1);
        if(!SW1){
            if(ButtonPressed){
                while(true){
                        select1.write(0);
                        display.write(digits[dig1]);
                        wait_ms(PERIOD_MS);
                        select1.write(1);
                        select2.write(0);
                        display.write(digits[dig2]);
                        wait_ms(PERIOD_MS);   
                } 
            }
        }
        else{
            ButtonPressed = 1;       
        }
        
        wait(PERIOD);*/ 
    }
    
}

/*
 * Definicija funkcija:
 */
 void ISR_sw1()
{
    buzz.write(0);
}