/*
*Biblioteke za uvoz
*/
#include <mbed.h>

/*
 * Definisanje makroa:
 */
 #define PERIOD 0.1
 #define PERIOD_MS 20
 
 /*
 * Globalne promenljive:
 */
 //               a      b     c     d      e    f     g
 BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
 DigitalOut select1(PB_6);
 DigitalOut select2(PC_7);
 DigitalIn SW1(PC_9);
 
static int digits[] = { // G, F, E, D, C, B, A 
                          0xC0,  // NULA
                          0xF9,  // JEDAN
                          0xA4,  // DVA
                          0xB0,  // TRI
                          0x99,  // CETIRI
                          0x92,  // PET
                          0x82,  // SEST
                          0xF8,  // SEDAM
                          0x80,  // OSAM
                          0x90,  // DEVET
                          0xFF   // UGASI       
                         };
 
/*
 * Deklaracija funkcija:
 */
 
 
/*
 * Glavna funkcija:
 */
 int main(){
    // Inicijalizacija i funckije koje se jednom izvrsavaju:
    static char ButtonPressed = 0;
    int i = 0, j = 0;
    
    select1.write(1);
    select2.write(0);
    
    display.write(digits[0]);
    
    while(true){
        if(!SW1){
            if(ButtonPressed){
                if(i <= 9){
                    display.write(digits[i]);
                }
                else {
                    select1.write(0);
                    display.write(digits[1]);
                    wait_ms(PERIOD_MS);
                    select1.write(1);
                    select2.write(0);
                    display.write(digits[j]);
                    wait_ms(PERIOD_MS);
                    select2.write(1); 
                    j++;                           
                } 
                i++;
                if(i == 16){
                    select2.write(0);
                    display.write(digits[0]);
                    break;        
                }
        
                ButtonPressed = 0;    
            } 
              
        }
        else{
            ButtonPressed = 1;       
        }
        
        wait(PERIOD);
        
        
        
    }
    
    
    
    
    
    
    
         
}

/*
 * Definicija funkcija:
 */