#include "mbed.h"

#define PWM_SPEED_R 0.7
#define PWM_SPEED_L 0.7

#define PWM_ARM 0.3
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX,USBRX);

//right_moter
PwmOut R_PWM(p23);
DigitalOut RF(p16);
DigitalOut RB(p17);

//left_moter
PwmOut L_PWM(p21);
DigitalOut LF(p13);
DigitalOut LB(p14);

//arm_moter(main)
PwmOut arm1(p22);
DigitalOut a1_f(p8);
DigitalOut a1_b(p9);

//arm_moter(sub)
PwmOut arm2(p24);
PwmOut arm3(p25);
PwmOut arm4(p26);
DigitalOut arm_front(p28);
DigitalOut arm_back(p29);

void motor_mode(int x);
void help_print(void);
void arm(int d);
void def_pwm(double duty);

int main(void){
    char scan;
    int part=0;
    led1=1;
    led4=1;
    
    while(1) {
        led4=!led4;
        wait_ms(100);
        while(1) {
            if(pc.readable()) {
                scan = pc.getc();
                pc.printf("%c:",scan);
                led2=1;
                break;
            }else{
                RB=0;
                LF=0;
                RF=0;
                LB=0;
            }
        }
        
        switch(scan) {
            case 'w':
                part=1;
                break;
            case 's':
                part=2;
                break;
            case 'd':
                part=3;
                break;
            case 'a':
                part=4;
                break;

            case 'c':
                arm(1);
                break;
            case 'v':
                arm(-1);
                break;
            case 'z':
                arm(0);
                break;

            case '?':
                help_print();
                continue;
                
            default:
                part=0;
                break;
        }
        
        motor_mode(part);
        
        part=0;
    }

}

void motor_mode(int x){
    switch(x){
        case 1:     //上ボタン(w)を押したとき
        R_PWM=PWM_SPEED_R;
        L_PWM=PWM_SPEED_L;
        RF=1;
        RB=0;
        LF=1;
        LB=0;
        printf("UP\t");
//        wait(0.5);
        break;
        
        case 2:     //下ボタン(s)を押したとき
        R_PWM=PWM_SPEED_R;
        L_PWM=PWM_SPEED_L;
        RF=0;
        RB=1;
        LF=0;
        LB=1;
        printf("DOWN\t");
//        wait(0.5);
        break;
        
        case 3:     //右ボタン(d)を押したとき
        R_PWM=PWM_SPEED_R;
        L_PWM=PWM_SPEED_L;
        RB=1;
        LF=1;
        RF=0;
        LB=0;
        printf("RIGHT\t");
//        wait(0.5);
        break;
        
        case 4:     //左ボタン(a)を押したとき
        R_PWM=PWM_SPEED_R;
        L_PWM=PWM_SPEED_L;
        RB=0;
        LF=0;
        RF=1;
        LB=1;
        printf("LEFT\t");
//        wait(0.5);
        break;
        
        default:
        RB=0;
        LF=0;
        RF=0;
        LB=0;
        printf("STAY\t");
        break;
        
    }
}

void arm(int d){
    if(d==1){
        def_pwm(PWM_ARM);
        arm_front=1;
        arm_back=0;
        a1_f=1;
        a1_b=0;
        printf("front\r\n");
    }else if(d==-1){
        def_pwm(PWM_ARM);
        arm_front=0;
        arm_back=1;
        a1_f=0;
        a1_b=1;
        printf("back\r\n");
    }else{
        def_pwm(0.0);
        arm_front=0;
        arm_back=0;
        a1_f=0;
        a1_b=0;
        printf("stop\r\n");
    }
}

void def_pwm(double duty){
    arm1=duty;
    arm2=duty;
    arm3=duty;
    arm4=duty;
}

void help_print(void){
    pc.printf("HELP!\r\n足回り\t:'w'前進's'後退'd'右旋回'a'左旋回\r\n回収機構:'c'正転'v'逆転'z':停止\r\n");
}