#include "mbed.h"
#include "DS1820.h"
 
#define DATA_PIN        A1

I2C i2c(p28,p27); 
DS1820 probe(DATA_PIN);


int batteryVoltage;
double YX;
double ZX;

double acc_ax;
double XX;
const int addr_accel_gyro = 0xD0;
short int xl,xh,yl,yh,zl,zh;
char cmd[2];
DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);
AnalogIn   toonUtga(p15);
Serial serial(USBTX,USBRX);
Serial xbee(p9,p10);



int batLevel(int x, int in_min, int in_max, int out_min, int out_max); 
void temp_hemjilt();
void Gyro_tohiruulga();
void Gyro_hemjilt();
void battery_hemjilt();
void data_send();
void gps_hemjilt();
int main() {
  
  wait(1);
      i2c.frequency(100000);
    cmd[0] = 0x6B;
    cmd[1] = 0x00;
    i2c.write(addr_accel_gyro,cmd,2);
    cmd[0]= 0x37;
    cmd[1]= 0x02;
    i2c.write(addr_accel_gyro,cmd,2);
    i2c.stop();
    
    //Gyro_tohiruulga();
    xbee.baud(9600);
    serial.baud(9600);
 /*
    int rcmd = 0; 
    int cmdflag = 0;
    for(int i = 0; i< 10; i++)
    {
        xbee.printf("num = %d\r\n",i);
       
        serial.printf("rcmd=%d,cmdflag = %\r\n",rcmd,cmdflag);
        
        if(cmdflag == 1)
        {
            if(rcmd == 'a')
            {
                serial.printf("Command Get %d\r\n",rcmd);
                xbee.printf("HEPTA uplink OK\r\n");
            }
             //   xbee.initialize();
       }  
    }       */
        
   // int batteryVoltage = 0;

    while(1) {
       
     temp_hemjilt();
     Gyro_hemjilt();
     battery_hemjilt();
     gps_hemjilt();
     data_send();
     // printf("%f %f %f\n" ,XX,YX,ZX);
 wait(1);
    }
}
void gps_hemjilt()
{
}
    
void battery_hemjilt()
{
    
 batteryVoltage = toonUtga.read_u16(); //12-bit ADC  (read_u16() /65535)  batLevel(toonUtga.read_u16(), 4000,2305, 0,100);
 if(61600 <=  batteryVoltage)    batteryVoltage = 61600;
   
 else if( 42000 >=batteryVoltage ) batteryVoltage = 42000;
 
 batteryVoltage = batLevel(batteryVoltage , 42000, 61600, 0, 100);
    serial.printf("tseneg=%d ",batteryVoltage); 
//        printf("normalized: %d \n", batteryVoltage );
        }
int batLevel(int x, int in_min, int in_max, int out_min, int out_max) {
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
void data_send()
{   xbee.printf("gyro x=%f y=%f z=%f " ,XX,YX,ZX);
    xbee.printf("tseneg=%d ",batteryVoltage);
    xbee.printf("temp %3.1foC\r\n", probe.temperature());

}
void Gyro_tohiruulga()
{
    
    i2c.frequency(100000);
    cmd[0] = 0x6B;
    cmd[1] = 0x00;
    i2c.write(addr_accel_gyro,cmd,2);
    cmd[0]= 0x37;
    cmd[1]= 0x02;
    i2c.write(addr_accel_gyro,cmd,2);
    i2c.stop();
    }
void temp_hemjilt()
{
            probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
       printf("It is %3.1foC\r\n", probe.temperature());
}
void Gyro_hemjilt()
{
    
i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x3b); // read
i2c.start();
i2c.write(addr_accel_gyro | 0x01);
xh = i2c.read(0);
i2c.stop();
i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x3c);
i2c.start();
i2c.write(addr_accel_gyro|0x01);
xl = i2c.read(0);
i2c.stop();
 acc_ax = short((xh<<8) | (xl));
 XX = (acc_ax)*2/32764*9.81;

i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x3d); // read
i2c.start();
i2c.write(addr_accel_gyro | 0x01);
yh = i2c.read(0);
i2c.stop();
i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x3e);
i2c.start();
i2c.write(addr_accel_gyro|0x01);
yl = i2c.read(0);
i2c.stop();
 acc_ax = short((yh<<8) | (yl));
 YX = (acc_ax)*2/32764*9.81;

i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x3f); // read
i2c.start();
i2c.write(addr_accel_gyro | 0x01);
zh = i2c.read(0);
i2c.stop();
i2c.start();
i2c.write(addr_accel_gyro);
i2c.write(0x40);
i2c.start();
i2c.write(addr_accel_gyro|0x01);
zl = i2c.read(0);
i2c.stop();
 acc_ax = short((zl<<8) | (zl));
 ZX = (acc_ax)*2/32764*9.81;

//printf("%f %f %f\n" ,XX,YX,ZX);

    }
