#include "mbed.h"
// Need include below to add the RTOS
#include "rtos.h"
#include "EthernetInterface.h" //needed for Extra Credit
#include "NTPClient.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "TMP36.h"
#include "wave_player.h"
#include "RGB.h"
#include "time.h"
// Setup four builtin leds for use by threads
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogOut DACout(p18); // used to play sound on speaker

//wave player plays a *.wav file to D/A and a PWM
wave_player waver(&DACout);

uLCD_4DGL uLCD(p9, p10, p11); // serial tx, serial rx, reset pin;
Mutex lcd_mutex;

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card setup
RGBLed myled(p24, p23, p22);
inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

// Setup function code for three new threads to run.
// Put in a while loop so that threads run forever.
// Thread::wait will force at least a "x" millisecond
// wait before the thread runs again. During this delay
// the other threads will run
// DO NOT use wait() with the RTOS!!!!!
// wait just burns processor time and no other threads run
void led2_thread(void const *argument)
{
    led2 = 1;
    while (true) {
        // set up a timer to be used for sample rate interrupts
        myled.write(random_number(),0.0,0.0);
        wait(0.5);
        myled.write(0.0,0.0,1.0-random_number());
        led2 = !led2;
        Thread::wait(2000);
    }
}
void led3_thread(void const *argument)
{
    led3 = 1;
    while (true) {
    // precompute 128 sample points on one sine wave cycle 
    // used for continuous sine wave output later
    FILE *p=fopen("/sd/fire.wav","r");;
    waver.play(p);
    fclose(p);
        led3 = !led3;
        Thread::wait(4000);
    }
}
void led4_thread(void const *argument)
{
    TMP36 myTMP36(p15);
    led4 = 1;
    while (true) {
        float tempC = myTMP36.read();
        //convert to degrees F
        float tempF = (9.0*tempC)/5.0 + 32.0;
        //print current temp
        lcd_mutex.lock();
        uLCD.locate(1,4);  
        uLCD.printf("%5.2F C  %5.2F F \n\r", tempC, tempF);
        lcd_mutex.unlock();
        led4 = !led4;
        Thread::wait(8000);
    }
}

int main()
{
    led1 = 1;
// code to set time in extra credit option goes here
    {
        EthernetInterface eth;
        NTPClient ntp;
        eth.init(); //Use DHCP
        wait(2);
        uLCD.cls();
        uLCD.printf("\nGetting IP Address\r\n");
        if(eth.connect(60000)!=0) {
            uLCD.printf("DHCP error - No IP\n");
            set_time(1360000000); //starts RTC
            wait(10);
        } 
        else {
            uLCD.printf("IP is %s\n", eth.getIPAddress());
            wait(2);
        }
        uLCD.printf("\nTrying to update time via NTP...\r\n");
        if (ntp.setTime("0.pool.ntp.org") == 0)
        {
            ntp.setTime("0.pool.ntp.org");
            uLCD.printf("Set time successfully\r\n");
        }
        wait(2);
        uLCD.cls();
    }
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    uLCD.text_width(2); //2x size text
    uLCD.text_height(2);
// Create 3 new thread objects thread1, thread2, and thread3
// The RTOS will immediately start running them
    Thread thread1(led2_thread);
    Thread thread2(led3_thread);
    Thread thread3(led4_thread);
// Main continues to run and is actually the first thread.
// So a total of four threads are running now.
// Each thread blinks an LED, but at a different rate
// because of the different values used in Thread::wait().
//
// Set time in seconds since Jan 1 1970 (Unix style)
// must set time to start Real Time clock running
    char buffer[12];
    time_t seconds;
    while (1) {
// reads time structure
        seconds = time(NULL);
// converts time structure to a string
        strftime(buffer, 12, "%T", localtime(&seconds));
// print time HH:MM:SS
        lcd_mutex.lock();
        uLCD.locate(0,2);
        uLCD.printf("%s\n\r", buffer);
        lcd_mutex.unlock();
        Thread::wait(1000);
    }
}
