
#include "mbed.h"
#include "XNucleoIKS01A2.h"

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);

/* Retrieve the composing elements of the expansion board */
static LSM303AGRMagSensor *magnetometer = mems_expansion_board->magnetometer;
static HTS221Sensor *hum_temp = mems_expansion_board->ht_sensor;
static LPS22HBSensor *press_temp = mems_expansion_board->pt_sensor;
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
static LSM303AGRAccSensor *accelerometer = mems_expansion_board->accelerometer;

// Create a DigitalOut objects for the LED
DigitalOut led(LED1);

// Create a Serial objects to communicate via USB
Serial pc(USBTX, USBRX);

// Create 2 Ticker objects for a recurring interrupts. One for blink a LED and the other one to update the sensor lectures periodicly.
Ticker blinky; 
Ticker update;

volatile float TEMPERATURE_C;
volatile float TEMPERATURE_F;
volatile float TEMPERATURE_K;
volatile float HUMIDITY;
volatile float PRESSURE;

bool measurements_update = false;

void blinky_handler(){
    led = !led;
}

void sensors_handler(){
    measurements_update = true;
}

int main() {
    
    /* Create a sensor shield object */
    // static X_CUBE_MEMS *Sensors = X_CUBE_MEMS::Instance();

    /* Enable all sensors */
    hum_temp->enable();
    press_temp->enable();
    magnetometer->enable();
    accelerometer->enable();
    acc_gyro->enable_x();
    acc_gyro->enable_g();

      /* Attach a function to be called by the Ticker objects at a specific interval in seconds*/
    blinky.attach(&blinky_handler, 0.5);
    update.attach(&sensors_handler, 3);
    
    while(1) {
        if(measurements_update == true){
            /* Read the environmental sensors  */
            hum_temp->get_temperature((float *)&TEMPERATURE_C);
            hum_temp->get_humidity((float *)&HUMIDITY);
            press_temp->get_pressure((float *)&PRESSURE);
            
            TEMPERATURE_F = (TEMPERATURE_C * 1.8f) + 32.0f; //Convert the temperature from Celsius to Fahrenheit
            TEMPERATURE_K = (TEMPERATURE_C + 273.15f);          //Convert the temperature from Celsius to Kelvin
            pc.printf("Temperature:\t %.2f C / %.2f F / %.2f K\r\n", TEMPERATURE_C, TEMPERATURE_F, TEMPERATURE_K);
            pc.printf("Humidity:\t %.2f%%\r\n", HUMIDITY);
            pc.printf("Pressure:\t %.2f hPa\r\n", PRESSURE); 
            pc.printf("\r\n");
                    
            measurements_update = false;
        }
        __wfi();
    }
}
