#include "mbed.h"
#include <string.h>
#include "servo.h"
#include "command_decoder.h"

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

Serial uart(USBTX, USBRX);

Servo myServo;
Ticker myTimer;
Token myToken;

unsigned char UART_puts(char * pcString, unsigned char ucSize)
{
    unsigned char ucLoopCounter;
    if( *(pcString + ucSize - 1) != NULL ) return 1;
    for(ucLoopCounter = 0; ucLoopCounter < (ucSize-1); ucLoopCounter++) {
        uart.putc(pcString[ucLoopCounter]);
    }
    uart.putc('\r');
    return 0;
}

unsigned char UART_gets(char *pcDestString, unsigned char ucSize)
{
    unsigned char ucLoopCounter;
    for(ucLoopCounter = 0; ucLoopCounter < (ucSize-1); ucLoopCounter++) {
        pcDestString[ucLoopCounter] = uart.getc();
        if(pcDestString[ucLoopCounter] == '\r') {
            pcDestString[ucLoopCounter] = NULL;
            return 0;
        }
    }
    return 1;
}

void ServoUpdate (void){
    myServo.Automat();
}

int main()
{
    uart.baud(9600);
    char acUartBuffor[15];
    
    myTimer.attach(&ServoUpdate, 0.2);
    
    myServo.Callib();
    
    while(1) {

        if (uart.readable()){
            UART_gets(acUartBuffor,15);
            myToken.DecodeMsg(acUartBuffor);
            
            if( (myToken.ucTokenNr != 0) && (KEYWORD == myToken.asToken[0].eType) )
            {
                switch(myToken.asToken[0].uValue.eKeyword)
                {
                    case ID:
                        UART_puts("ID 1234\n", 9);
                        break;
                        
                    case CALIB:
                        myServo.Callib();
                        UART_puts("ok\n", 4);
                        break;
                    
                    case GOTO:
                        UART_puts("ok\n", 4);
                        myServo.GoTo(myToken.asToken[1].uValue.uiNumber);
                        break;
                    
                    case STEP:
                        UART_puts("ok\n", 4);
                        myServo.StepRight(myToken.asToken[1].uValue.uiNumber);
                        break;
                }
            }
            else if((myToken.ucTokenNr != 0)){
                UART_puts("unknowncommand\n", 16);
            }
        
        } 
        
    }
}
