#ifndef COMMAND_DECODER_H
#define COMMAND_DECODER_H

#define MAX_TOKEN_NR 2      
#define MAX_KEYWORD_STRING_LTH 10 
#define MAX_KEYWORD_NR 4


enum CharacterType {TOKEN, DELIMITER}; 
enum TokenType {KEYWORD, NUMBER, STRING};
enum KeywordCode { ID, CALIB, GOTO, STEP };

struct Keyword {
    
    enum KeywordCode eCode;
    char cString[MAX_KEYWORD_STRING_LTH + 1];
};


union TokenValue {
    
    enum KeywordCode eKeyword;      // jezeli KEYWORD
    unsigned int uiNumber;          // jezeli NUMBER
    char * pcString;                // jezeli STRING
};

struct tToken {
    
    enum TokenType eType;           // KEYWORD, NUMBER, STRING
    union TokenValue uValue;        // enum, unsigned int, char*
};

class Token {

private:
    unsigned char ucFindTokensInString (char *pcString);
    void DecodeTokens(void);
    enum Result eSringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode);
    enum Result eHexStringToUInt(char pcStr[],unsigned int *puiValue);
    void ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar);
public:  
    struct tToken asToken[MAX_TOKEN_NR];
    unsigned char ucTokenNr;
    void DecodeMsg(char *pcString);
};


#endif
