#ifndef SERVO_H
#define SERVO_H
#include "led.h"

enum ServoState {CALLIB, IDLE, IN_PROGRESS};
enum DetectorState {ACTIVE, INACTIVE};

class Servo {
    
private:
    Led myLed;
    enum DetectorState eReadDetector();
    enum ServoState eState;
    unsigned int uiCurrentPosition;
    unsigned int uiDesiredPosition;
    
public:    
    void Automat();
    void Callib(void);
    void GoTo(unsigned int uiPosition);
    void StepRight(unsigned int uiSteps);
};

#endif
