#include "led.h"

Led::Led (void){
    ucServoPos = 0;
    unsigned char ucCurrentLed;
    lcd.SetFont(&Font24);
    lcd.Clear(LCD_COLOR_WHITE);
    
    lcd.SetTextColor(LCD_COLOR_BLACK);
    for( ucCurrentLed = 1; ucCurrentLed < 5; ucCurrentLed++ ){
        lcd.FillCircle((ucCurrentLed*50)-5,260,20);
    }
}

void Led::On(unsigned char ucLedIndeks){
    
    unsigned char ucCurrentLed;
    float posX, posY;
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(120,120,90);
    
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(120, 120, 10);
    
    for( ucCurrentLed = 1; ucCurrentLed < 5; ucCurrentLed++ )
    {
        lcd.FillCircle((ucCurrentLed*50)-5,260,16);
    }
    
    posX = 120 + (90 * sin((0.131 * ucServoPos)));
    posY = 120 + (90 * cos((0.131 * ucServoPos)));
    lcd.DrawLine(120, 120, posX, posY);
    
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillCircle(((ucLedIndeks+1)*50)-5,260,16);
    
}

void Led::Step (enum LedDirection Direction){
    
    static unsigned int uiLedCounter = 0;
    
    if(Direction == LEFT)
    {
        uiLedCounter++;
    }
    else
    {
        uiLedCounter--;
    }
    On(uiLedCounter%4);
}

void Led::StepLeft(void){
    if(ucServoPos < 47)
    {
        ucServoPos++;
    }
    else
    {
        ucServoPos = 0;
    }
    Step(LEFT);
}

void Led::StepRight(void){
    if(ucServoPos > 0)
    {
        ucServoPos--;
    }
    else
    {
        ucServoPos = 47;
    }
    Step(RIGHT);
}
