#include "command_decoder.h"
#include <string.h>
#include <stdlib.h>

#define TERMINATOR 0x20

enum Result { rOK, rERROR };

struct Keyword asKeywordList[MAX_KEYWORD_NR] = {
    {ID, "id"},
    {CALIB,"calib"},
    {GOTO, "goto" },
    {STEP, "step" }
};

unsigned char Token::ucFindTokensInString (char *pcString){
    
    unsigned char ucCharacterCounter = 0, ucCurrentCharacter;
    enum CharacterType eCharacterType = DELIMITER;
    unsigned char ucTokenCounter = 0;
    
    for(ucCharacterCounter = 0; ;ucCharacterCounter++){
        
        ucCurrentCharacter = pcString[ucCharacterCounter];
        
        switch(eCharacterType){
            
            case TOKEN:
                if(ucCurrentCharacter == NULL){
                    return ucTokenCounter;
                }
                else if(ucTokenCounter == MAX_TOKEN_NR){
                    return ucTokenCounter;
                }
                else if(ucCurrentCharacter == ' '){
                    eCharacterType = DELIMITER;
                }
                break;
                
            case DELIMITER:
                if(ucCurrentCharacter == NULL){
                    return ucTokenCounter;
                }
                else if(ucCurrentCharacter == ' '){
                    eCharacterType = DELIMITER;
                }
                else{
                    asToken[ucTokenCounter].uValue.pcString = (pcString + ucCharacterCounter);
                    ucTokenCounter++;
                    eCharacterType = TOKEN;
                }
                break;
        }
    }
}

enum Result Token::eSringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode){
    
    unsigned char ucKeywordCounter;
    
    for(ucKeywordCounter = 0; ucKeywordCounter < MAX_KEYWORD_NR; ucKeywordCounter++){
        
        if(0 == strcmp(asKeywordList[ucKeywordCounter].cString, pcStr)){
            *peKeywordCode= asKeywordList[ucKeywordCounter].eCode;
            return rOK;
        }       
    }
    return rERROR;
}

enum Result Token::eHexStringToUInt(char pcStr[],unsigned int *puiValue){
    
    if((pcStr[0] != '0') || (pcStr[1] != 'x') || (pcStr[2] == NULL)) {
        return rERROR;
    }
    
    pcStr[0] = pcStr[3];
    pcStr[1] = pcStr[4];
    pcStr[2] = NULL;
    
    *puiValue = atoi(pcStr);

    return rOK;
}

void Token::ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar){
    
    unsigned char ucCharacterCounter;
    
    for( ucCharacterCounter = 0; pcString[ucCharacterCounter] != NULL; ucCharacterCounter++ ) {
        if( pcString[ucCharacterCounter] == cOldChar) pcString[ucCharacterCounter] = cNewChar;
    }
}

void Token::DecodeTokens(void){
    
    unsigned char ucTokenCounter;
    struct tToken * pToken;
    
    for(ucTokenCounter = 0; ucTokenCounter < ucTokenNr; ucTokenCounter++){
        pToken = &asToken[ucTokenCounter];
        
        if(rOK == eSringToKeyword(pToken->uValue.pcString, &pToken->uValue.eKeyword)){
            pToken->eType = KEYWORD;
        }
        else if(rOK == eHexStringToUInt(pToken->uValue.pcString, &pToken->uValue.uiNumber)){
            pToken->eType = NUMBER;
        }
        else{
            pToken->eType = STRING;
        }
    }
}

void Token::DecodeMsg(char *pcString){
    
    ucTokenNr = ucFindTokensInString(pcString);
    ReplaceCharactersInString(pcString, ' ', NULL);
    DecodeTokens();
}
