#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucColumn)
{
    ucXLed = ucColumn * 80;
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetFont(&Font24); 
}

void LedLcd::On(unsigned char ucCtr)
{
    const char* btnText[] = {"0", "1", "2", "3"};
    
    for(uint8_t i = 0; i < 4; i++) 
    {
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucXLed, i*80, 80, 80); 
        if( ucCtr == i ) 
        {
            lcd.SetTextColor(LCD_COLOR_YELLOW);
        }
        else 
        {
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(ucXLed+1, (80*i)+1 , 78, 78);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(ucXLed, i*80, (uint8_t *) btnText[i], LEFT_MODE);
    }
}
