#include "mbed.h"
#include "M2XStreamClient.h"
#include "EthernetInterface.h"
#include "DHT.h"                // Humidity & Temperature Sensor

// Initialize Serial port
Serial pc(USBTX, USBRX); // tx, rx

// Data in pins
AnalogIn loudness_sensor(A0);
DHT DHT_sensor(D0, DHT11); //(DATA_PIN, BOARD_TYPE)

// Set Sensor Stream details
char deviceId[]     =   "8dbeb7825cb54a8ed08d0141c9dc107d";    //// Device you want to push to
char streamHum[]    =   "hum_rms";   // Stream you want to push to
char streamTem[]    =   "temp_rms";  // Stream you want to push to
char streamLou[]    =   "loud_rms";  // Stream you want to push to
char m2xKey[]       =   "db1a8ab5772dd536069f9901e09e4590";      // Your M2X API Key or Master API Key

int main()
{
    pc.baud(115200);
    
    // Intialize and connect to Ethernet connection
    EthernetInterface eth;
    printf("Waiting for eth.init()\r\n");
    eth.init();
    eth.connect();
    printf("Success. Connected! Device IP Address is %s\r\n", eth.getIPAddress());

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
    int ret;
    
    // Data vars
    float hum_rms = 0.0f;
    float temp_rms = 0.0f;
    float loud_rms = 0.0f;
    
    // Degree character 'º' ASCII value
    char degree_char = 167;
    
    int DHT_error = 0; 
    
    printf("Begin data acquisition from sensors and sending data to M2X...\r\n\r\n");
    wait(.5);
    
    while(1)
    {
        wait_ms(250);
        DHT_error = DHT_sensor.readData();
        
        
        // Get data
        if(DHT_error != 0)
        {
            temp_rms = DHT_sensor.ReadTemperature(FARENHEIT);
            hum_rms = DHT_sensor.ReadHumidity();
        } // end if
        
        loud_rms = 100*loudness_sensor.read();
        
        // High temperature
        if(temp_rms >= 77 && temp_rms < 80)
        {
            printf("------------------------------------------------------------------------\r\n");
            printf("The temperature is over 77%cF, turn on the AC!\r\n", degree_char);
        }
        else if(temp_rms >= 80)
        {
            printf("------------------------------------------------------------------------\r\n");
            printf("The temperature is over 80%cF! Call 911 and get home immediately!\r\n", degree_char);
        }
        
        // High humidity
        if(hum_rms >= 50)
        {
            printf("------------------------------------------------------------------------\r\n");
            printf("The humidity is over 50%%, turn on the AC!\r\n");
        }
        
        // Noise detected
        if(loud_rms > 99)
        {
            printf("------------------------------------------------------------------------\r\n");
            printf("There's noise in the home! Could be an intruder!\r\n");    
        }
        
        
        /*// Print data
        printf("Tmeperature: %4.2f%cF\n", temp_rms, degree_char);               // "0000.00ºF"
        printf("Humidity: %4.2f\n", hum_rms);                                   // "0000.00%"
        printf("Loudness: %.2f%%\r\n", loud_rms);                               // "000.00%"
        */
        // Send data to M2X Client, and print return value
        m2xClient.updateStreamValue(deviceId, streamHum, hum_rms);
        //printf("send() returned %d\r\n", ret);
        m2xClient.updateStreamValue(deviceId, streamTem, temp_rms);
        //printf("send() returned %d\r\n", ret);
        m2xClient.updateStreamValue(deviceId, streamLou, loud_rms);
        //printf("send() returned %d\r\n", ret);
    } // end while()

} // end main()

