
#include "mbed.h"
#include "DHT.h"
#include "BMP180.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "iostream"
 
 
// networking stuff
EthernetNetIf eth;
HTTPClient http;
 
 
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "ACRZWAPJ8A7M4ZNA";
 
char urlBuffer[256];
char timeBuffer[64];

DigitalOut myled(LED1);
DigitalOut myled1(LED4);

DHT sensor (p23,DHT11); //Use the sensor
Serial pc(USBTX,USBRX);

DigitalOut myled3(LED3);
DigitalOut ledPower(p26);

BusOut myled2(p21,p24);//to set the state of the output pin

AnalogIn analog_value(p18);
AnalogIn LDR(p20);

I2C i2c(p9,p10);
BMP180 bmp180(&i2c);

AnalogIn water(p17);

DigitalIn infrared(p22);
DigitalOut myled22(p25);

int samplingTime = 280; //280 microseconds
int deltaTime = 40; //40 us to give total pulse width of 0.32ms
int sleepTime = 9680; //LED off for 9680 us to take 1 measurement per second 

float dustDensitySharp = 0,
voMeasured=0, voCalc=0;

float value;           
float level;

int isObstacle;
int reading;
int pressure;
int main()
{
    printf("Start\r\n");
 
    printf("Setting up Ethernet...\r\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in ethernet setup.\r\n", ethErr);

    }
    printf("Ethernet setup OK\r\n");


    
    
    
    
    while (1)
    {
          //wait 1 second for device stable status
    
      
        wait(1);   //wait 1 sec for device stable status
    
      {  myled = 1;
        reading = sensor.readData();
        if (reading == 0)
        {
            printf("\r\nDHT11 HUMIDITY");
            printf("\r\n************************************\r\n");
            wait(1);
            pc.printf("Temperature is %4.2f C\r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F\r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K\r\n",sensor.ReadTemperature(KELVIN));
            
            
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            pc.printf("Dew point is %4.2f \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS),sensor.ReadHumidity()));
            pc.printf("Dew point (fast)is %4.2f \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS),sensor.ReadHumidity()));
            wait(1);
            }
            else
               {
                 printf("\r\nreading %i \n",reading);
                myled = 0;
                wait (1.0);
             }
             
        }    
    {
     myled3 = !myled3;
     
     ledPower=0;   //power on the LED. Pull-down to activate
     wait_us(samplingTime);
     voMeasured = analog_value;  //Converts and read the analog input value
     wait_us(deltaTime);
     ledPower=1; //turn the LED off.Pull up to turn off
     wait_us(sleepTime);
     
     voCalc = voMeasured * 3.3; //Map 0:1 measured range to 0:3.3V
     
     dustDensitySharp = 0.5/2.8 * (float(voCalc)- 0.7);
    printf("\r\nGP2Y1010AU0F DustSensor");
    printf("\r\n**********************\r\n");
     
     pc.printf("Sharp's Dust Density [mg/m3]:= %f\n\r",dustDensitySharp); //send temp to PC
     
     wait(1);
     
     
     
     
 }    
     
     {
      if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
           
        }
        wait(1);
        }
        
     {
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete
        float temp;
        if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
            continue;
        }

        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        

        printf("\r\nBMP180 Pressure");
        
    printf("\r\n*******************************\r\n");
    wait(1);  //wait 1 second for device stable status
    
        if(bmp180.getPressure(&pressure) != 0) {
            printf("Error getting pressure\n");
            continue;
        }

        pc.printf("Pressure = %d Pa Temperature = %f C", pressure);
        pc.printf("\r\nTemp is %4.2f degC\r\n",temp);  
        pc.printf("\r\nPressure = %d Pa     Temperature = %f C\n",pressure,temp);
        wait(1);
        

        }
        {
             printf("\r\nLDR SENSOR");
             
             printf("\r\n********************************\r\n");
        wait(1); //wait 1 second for device stable status
        
        myled = LDR.read_u16()/65; //2^16 durch 10
        
        pc.printf("\r%u%f\n",(LDR.read_u16()/64),LDR.read());
        
        wait(1);
        
        
        if(LDR.read()>0.120)
        {
            myled = 1;
        }
        
        
        else
        {
            myled = 0;
        }
        
        }
      {
       printf("\r\nWATER LEVEL SENSOR");
       printf("\r\n********************************\r\n");
       
       value = water.read(); //Read data from analog pin and store it to value variable
       level = value *100 ;
       pc.printf("\r\n%f",value);
        
        pc.printf("\r\n%f",level);
        
    if (level>0 && level<=10){ 
        pc.printf("\r\nWATER LEVEL VERY LOW!\r\n\r\n"); 
        pc.printf("WARNING : PLEASE ALERT!\r\n\r\n"); 
    }
    else if (level>10 && level<=25){ 
        pc.printf("\r\nWATER LEVEL is less than 5cm\r\n\r\n"); 
        pc.printf("\r\nWARNING : WATER LEVEL IS LOW!\r\n\r\n"); 
    }
    else if (level>25 && level<=55){ 
        pc.printf("\r\nWATER LEVEL is NORMAL\r\n\r\n"); 
    } 
     else if (level>55  && level<=60){ 
        pc.printf("\r\nWARNING :WATER LEVEL is HIGH\r\n\r\n");
   }
    wait(5); // Check for new value every 5 sec
    
        
    
    }
    
     
     {
     printf("INFRARED SENSOR");
     printf("\r\n********************************\r\n");
     
    isObstacle = infrared.read();
    //pc.printf("\r\n%i",isObstacle);
    
    if (isObstacle == 0){
        myled22 = 0;
        pc.printf("NO PARKING AVAILABLE\r\n\r\n");
        }
    else
    {
        pc.printf("AVAILABLE PARKING\r\n\r\n");
        myled22 = 1; 
        }
    wait(1);  
    
    }  
    
    urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?key=%s  &field1=%f  &field2=%f  &field3=%d  &field4=%u%f &field5=%f", thingSpeakUrl, thingSpeakKey,sensor.ReadHumidity(), dustDensitySharp, pressure,(LDR.read_u16()/64),LDR.read(),level);
        printf("Request to %s\r\n", urlBuffer);
       
        HTTPText resp;
        HTTPResult res = http.get(urlBuffer, &resp);
        if (res == HTTP_OK)
        {
            printf("Result :\"%s\"\r\n", resp.gets());
        }
        else
        {
            printf("Error %d\r\n", res);
        }
       
        wait(16); // limited by ThingSpeak's API
         
        
     
         
        
     }
   } 
 

          

        
         