#include "mbed.h"
#include <stdlib.h>
#include <VL6180x.h>
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "button_group.hpp"
#include <string>
#include "iut.h"

//Adresse du capteur
#define VL6180X_ADDRESS 0x29

// Procéde à l'identification du capteur
VL6180xIdentification identification;
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor(D14, D15, VL6180X_ADDRESS<<1);

//Communication avec le pc par USB
Serial pc(USBTX, USBRX);

//Mikami : pour la gestion des boutons
using namespace Mikami;

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;


//fonction printIdentification qui permet l'identification du capteur et l'affichage de ces caréctéristiques(modéle , version)
void printIdentification(struct VL6180xIdentification *temp)
{
    printf("\rModel ID = ");
    printf("%d\n",temp->idModel);

    printf("\rModel Rev = ");
    printf("%d",temp->idModelRevMajor);
    printf(".");
    printf("%d\n",temp->idModelRevMinor);

    printf("\rModule Rev = ");
    printf("%d",temp->idModuleRevMajor);
    printf(".");
    printf("%d\n",temp->idModuleRevMinor);

    printf("\rManufacture Date = ");
    printf("%d",((temp->idDate >> 3) & 0x001F));
    printf("/");
    printf("%d",((temp->idDate >> 8) & 0x000F));
    printf("/1");
    printf("%d\n",((temp->idDate >> 12) & 0x000F));
    printf(" \rPhase: ");
    printf("%d\n",(temp->idDate & 0x0007));

    printf("\rManufacture Time (s)= ");
    printf("%d\n",(temp->idTime * 2));
    printf("\n\n");
}
//Logo iut
void drawImage_iut(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)iut.data;
    while(y < iut.height) {
        while(x < iut.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

int main()
{

    wait_ms(2000);

    pc.baud(115200);//Pour régler la vitesse
    pc.printf("\r\nRUN\r\n");//envoie un message

    //unsigned int Button_reset = 0 ;
    unsigned  int valeur_capteur ;
    char buffer [50] ;

    unsigned int valeur_min = 30 ;
    unsigned int valeur_max = 150 ;
    int etat = 0 ; //si etat = 0 alors rien ne se passe / si etat =1 alors c'est la valeur min / si etat = 2 alors c'est la valeur max 

    
    //Initialisation de l'ecran
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font16);

    //Affichage de chaines de caréctérs (message de bienvenue et mesure)
    BSP_LCD_DisplayStringAt(35, 30, (uint8_t *)"BIENVENUE SUR UN CAPTEUR DE DISTANCE", CENTER_MODE);
    BSP_LCD_DisplayStringAt(5, 90, (uint8_t *)"Mesure", CENTER_MODE);

    //affichage du logo de l'iut
    drawImage_iut(0,0);

    //affichage des carectéristiques du capteur
    sensor.getIdentification(&identification); 
    printIdentification(&identification); 
 
    //test pour vérifier si le capteur a été bien initialisé
    if(sensor.VL6180xInit() != 0) 
    {
        printf("FAILED TO INITALIZE\n"); 
    };

    sensor.VL6180xDefautSettings(); 

    wait_ms(1000); // delay 1s


    //Switch : bouton min , max
    const string STR_SW[2] = {"MIN", "MAX"};
    BSP_LCD_SetFont(&Font20);
    ButtonGroup sw(lcd_, ts_, 10, 160, 66, 40,
                   LCD_COLOR_DARKBLUE,   LCD_COLOR_DARKBLUE, 2, STR_SW, 5, 0, 2);


    while(1) {
        //affichage de la lumiére ambiante en LUX
        printf("\r\nAmbient Light Level (Lux) = ");
        printf("%f",sensor.getAmbientLight(GAIN_1) );

        //Affichage de la distance en milimétres
        printf("\r\nDistance measured (mm) = ");
        printf("%d\n", sensor.getDistance() );

        //Stocker la distance dans la variable "valeur_capteur"
        valeur_capteur = sensor.getDistance() ;

        //Conversion
        sprintf(buffer, "%d", valeur_capteur);
        
        //paramétrage de l'écran et affichage de la distance
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
        BSP_LCD_SetFont(&Font20);
        BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)255, CENTER_MODE);
        
        //condition pour tester si le switch "MIN" est appuyé
        if (sw.Touched(0, LCD_COLOR_GREEN)) {
            BSP_LCD_SetFont(&Font20);
            BSP_LCD_DisplayStringAt(0, 210, (uint8_t *)"MIN = 30  ", CENTER_MODE);
            etat = 1 ; // etat 1 = etat MIN

        }
        
        //condition pour tester si le switch "MAX" est appuyé
        else if (sw.Touched(1, LCD_COLOR_RED)) {
            BSP_LCD_SetFont(&Font20);
            BSP_LCD_DisplayStringAt(0, 210, (uint8_t *)"MAX = 150  ", CENTER_MODE);
            etat =2 ; // etat 2 = etat MAX
        }

        
        else {
            // si etat=0 alors on affiche la mesure en continu 
            if(etat == 0) {
                BSP_LCD_SetBackColor(LCD_COLOR_YELLOW);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                BSP_LCD_SetFont(&Font20);
                BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);
                wait_ms(500);
                
            //sinon si etat=1 on teste alors si la valeur du capteur est supérieure ou égale à la valeur min
            } else if (etat ==1) {
                if(valeur_capteur >= valeur_min) {
                    BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
                    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                    BSP_LCD_SetFont(&Font20);
                    BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);
                } else {
                    BSP_LCD_SetBackColor(LCD_COLOR_RED);
                    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                    BSP_LCD_SetFont(&Font20);
                    BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);
                }
                //sinon si la valeur=2 n teste alors si la valeur du capteur est inférieure à la valeur max 
            } else if(etat == 2) {
                if(valeur_capteur <= valeur_max) {
                    BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
                    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                    BSP_LCD_SetFont(&Font20);
                    BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);

                } else {
                    BSP_LCD_SetBackColor(LCD_COLOR_RED);
                    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                    BSP_LCD_SetFont(&Font20);
                    BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);
                }
            }
        }
    }
}
