#include "mbed.h"
#include "C12832.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

// LCD Pinout
C12832 lcd(D11, D13, D12, D7, D10);

// MQTT Variables
char* MqttHostname = "broker.hivemq.com";
int MqttPort = 1883;
char* MqttTopic = "mbed-sample";
char* MqttClientId = "changeme";

int main()
{
    // Clear LCD and print a welcome message from row 0, col 0.
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Example MQTT client\n");

    // Brings up the network interface
    MQTTEthernet eth = MQTTEthernet();
    const char *ip = eth.get_ip_address();
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("IP address is: %s\n", ip ? ip : "No IP");
    
    // Create Mbed Client Interface
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(eth);

    // Create TCP connection
    eth.open(eth.getEth());
    int rc = eth.connect(MqttHostname, MqttPort);
    lcd.printf("TCP Status: %s\n", (rc == 0) ? "Success" : "Failure");
    
    // Wait for a short length of time to allow user to see output messages.
    Thread::wait(2000);
    
    if(rc == 0){
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Starting MQTT Client");

        MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
        data.MQTTVersion = 3;
        data.clientID.cstring = MqttClientId;
        rc = client.connect(data);
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("MQTT Client: %s\n", (rc == 0) ? "Connected" : "Failed");
        
        while(rc == 0){
            MQTT::Message message;
 
            // QoS 0
            char buf[100];
            sprintf(buf, "Hello World!");
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            rc = client.publish(MqttTopic, message);  
            
            Thread::wait(5000);

        }
    }
    
    // It is good practice to close the socket
    eth.disconnect();
}

