#ifndef __main_h_
#define __main_h_

#ifndef M_PI
    #define M_PI 3.14159265358979323f
#endif

//COMMAND
typedef enum command_character_t {
    //read commands
    READ_DIGITAL = 0, READ_POT, READ_TEMP, READ_BOARD_ACCEL, READ_SHIELD_ACCEL, READ_BOARD_MAGNO,
    //set commands
    SET_SHIELD_LED, SET_BOARD_LED, SET_PIEZO,
    //higher level get commands
    GET_ORIENTATION, GET_SIDE, GET_HEADING,
    //lcd commands
    SET_LCD_POSITION, PRINT_TEXT, SET_PIXEL, DRAW_CIRCLE, FILL_CIRCLE, DRAW_LINE, DRAW_RECT, FILL_RECT, CLEAR_LCD,
    //other commands
    RECONNECT, COMMAND_LENGTH
} command_character;

void read_digital();
void read_pot();
void read_temp();
void read_board_accel();
void read_shield_accel();
void read_board_magno();
void set_shield_led();
void set_board_led();
void set_piezo();
void get_orientation();
void get_side();
void get_heading();
void set_lcd_position();
void print_text();
void set_lcd_pixel();
void draw_circle();
void fill_circle();
void draw_line();
void draw_rect();
void fill_rect();
void clear_lcd();
void reconnect();

// Array of pointers to command handlers
void (*commandFunctions[COMMAND_LENGTH]) (void) = {
    read_digital, read_pot, read_temp, read_board_accel,  read_shield_accel, read_board_magno,
    
    set_shield_led, set_board_led, set_piezo,
    
    get_orientation, get_side, get_heading,
    
    set_lcd_position, print_text, set_lcd_pixel, draw_circle, fill_circle, draw_line, draw_rect, fill_rect, clear_lcd,
    
    reconnect
};

#endif // __main_h_
