#ifndef DATASERIAL
#define DATASERIAL

#include "mbed.h"

class DataSerial : public Serial
{
    public:
        DataSerial(PinName tx, PinName rx);
        ~DataSerial();
    
        void sendFloat(float &f);
        void sendInt16(uint16_t &i);
        void sendChar(char c);
        void sendBool(bool b);
        void sendData(void* data, uint8_t len);
        
        float readFloat();
        uint16_t readInt16();
        char readChar();
        uint8_t readString(char * s);
        void readData(void* data, uint8_t len);
        
        void sendSpecialCommand(char char1, char char2);
        
    protected:
        void readFailureMode();
};

#endif