#include "comms.h"

DataSerial::DataSerial(PinName tx, PinName rx) : Serial(tx,rx,NULL) {}

DataSerial::~DataSerial() {}

void DataSerial::sendFloat(float &f) {
    sendData(&f,sizeof(float));
}

void DataSerial::sendInt16(uint16_t &i) {
    sendData(&i,sizeof(uint16_t));
}

void DataSerial::sendChar(char c) {
    putc(1); putc(c);
}

void DataSerial::sendBool(bool b) {
    putc(1); putc(b ? 't' : 'f');
}

float DataSerial::readFloat() {
    float f;
    readData(&f,sizeof(float));
    return f;
}

uint16_t DataSerial::readInt16() {
    uint16_t i;
    readData(&i,sizeof(uint16_t));
    return i;
}

char DataSerial::readChar() {
    if(getc()!=1) readFailureMode();
    return getc();
}

void DataSerial::sendData(void* data, uint8_t len) {
    putc(len);
    for(char* c = (char*)data;len--;)
        putc(*(c++));
}

uint8_t DataSerial::readString(char * s) {
    char l = getc();
    uint8_t len = (uint8_t)l;
    while(l>0) {
        *s = getc();
        s++;
        l--;
    }
    return len;
}

void DataSerial::readData(void* data, uint8_t len) {
    char readLen = getc();
    if(readLen!=len) readFailureMode();
    char* c = (char*)data;
    while(len>0) {
        *c = getc();
        c++;
        len--;
    }
}

void DataSerial::sendSpecialCommand(char char1, char char2) {
    putc(0); putc(char1); putc(char2);
}

void DataSerial::readFailureMode() {
    DigitalOut lr(PTB22), lg(PTE26), lb(PTB21);
    lr=lg=1; lb=0;
    for(;;) {
        wait_ms(1000);
        lb=!lb;
    }
    
}