#include "mbed.h"
#include "SimonK_I2C_ESC.h"

#define ESC_ADDRESS 0x2B

I2C i2c(D14, D15);
SimonK_I2C_ESC motor(i2c, ESC_ADDRESS);
Serial pc(USBTX, USBRX);

int main() {
    i2c.frequency (400);
    motor.set(0);
    while(true){
        
        motor.update();
        pc.printf("ESC: ");
        
        if(motor.isAlive()) pc.printf("OK\t\t"); 
        else pc.printf("NA\t\t");
        
        pc.printf("%d",motor.rpm());pc.printf(" RPM\t\t");
        pc.printf("%f",motor.voltage());pc.printf(" V\t\t");
        pc.printf("%f",motor.current());pc.printf(" A\t\t");
        pc.printf("%f",motor.temperature());pc.printf(" `C");
        pc.printf("\n\r");

        wait_ms(250);
        //motor.set(10);

        
    }
}