#if !defined(MQTTSOCKET_H)
#define MQTTSOCKET_H

#include "MQTTmbed.h"
#include "TCPSocket.h"

class MQTTSocket
{
public:    

    int open(EthernetInterface& eth){
        return mysock.open(&eth);
    }    

    int connect(char* hostname, int port, int timeout=1000)
    {
        mysock.set_blocking(false);
        mysock.set_timeout(timeout);  
        return mysock.connect(hostname, port);
    }

    int read(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_blocking(false);
        mysock.set_timeout(timeout);  
        return mysock.recv((char*)buffer, len);
    }
    
    int write(unsigned char* buffer, int len, int timeout)
    {
        mysock.set_blocking(false);
        mysock.set_timeout(timeout);  
        return mysock.send((char*)buffer, len);
    }
    
    int disconnect()
    {
        return mysock.close();
    }
    
private:

    TCPSocket mysock; 
    
};



#endif
