
#if !defined(MQTTETHERNET_H)
#define MQTTETHERNET_H

#include "MQTTmbed.h"
#include "EthernetInterface.h"
#include "MQTTSocket.h"

class MQTTEthernet : public MQTTSocket
{
public:    
    MQTTEthernet()
    {
        connectInterface();  
    }
    
    EthernetInterface& getInterface()
    {
        return eth;
    }
    
    EthernetInterface& getEth() __attribute__ ((deprecated))
    {   
        return eth;
    }
    
    const char * get_ip_address()
    {
        return eth.get_ip_address();
    }
    
    int connectInterface(){
        return eth.connect();   
    }    

    int reconnectInterface()
    {
        disconnect();
        return eth.connect();
    }
    
    int disconnectInterface()
    {
        return eth.disconnect(); 
    }
    
private:

    EthernetInterface eth;
    
};


#endif
