#include "mbed.h"
#include "TextLCD.h"
#define max 5
#include "SDFileSystem.h"




AnalogIn V1_VALUE(A0);
AnalogIn V2_VALUE(A1);
AnalogIn V3_VALUE(A2);
AnalogIn V4_VALUE(A3);
DigitalOut led(A4);
DigitalIn mybutton(USER_BUTTON);
DigitalIn mybutton1(D2);
DigitalIn mybutton2(D3);
DigitalIn mybutton3(A5);

Serial pc(USBTX, USBRX);
Timer t;
Timer t1;
Timer t2;
Timer t3;
Timer t4;

TextLCD lcd(D8, D9, D4, D5, D6, D7, TextLCD::LCD20x4);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;


        float V1,V2,V3,V4,VTOTAL,m,m1,m2,m3,m4,stat,stat1,stat2,stat3,abc1,abc2,abc3,abc4;
        float x1=19.2225579;
        float x2=19.2643794;
        float x3=19.1854839;
        float x4=19.1653226;
        int n=1000;
        int p,z,x,c,d,d1,d2,d3,d4,jam,number;
  
int main()
{       
        
        restart:
        
        int count=0;
        float jum1,jum2,jum3,jum4;
        
        lcd.cls ();
        lcd.locate (0, 0);
        lcd.printf ("********************");
        lcd.locate (0, 1);
        lcd.printf ("*    Alat Ukur     *");
        lcd.locate (0, 2);
        lcd.printf ("*Pengujian Battery *");
        lcd.locate (0, 3);
        lcd.printf ("********************");
        
        while(1)
        {
            if (mybutton == 0){
                 p = 1; 
                 break;
            }
        }
              
         loop:
         //SDCARD =====================================     
        lcd.cls();
        //pc.printf("Initializing\r\n");
        lcd.printf("Initializing");
        wait(0.1);
        lcd.cls();
        lcd.printf("Initializing.");
        wait(0.1);
        lcd.cls();
        lcd.printf("Initializing..");
        wait(0.1);
        lcd.cls();
        lcd.printf("Initializing...");
        wait(0.1);
        

        char buf [10];  
        number %= 1000000;
        sprintf(buf,"/sd/data%d.csv",number); 
        fp = fopen(buf, "r");
        if (fp != NULL) {
        fclose(fp);
        number++;
        //pc.printf("data%d\r\n",number);
        lcd.locate(0, 1);
        lcd.printf("data%d\r\n",number);
        wait(1.0);
        goto loop;
        }
        
        if (number == 0) {
        number++;
        goto loop;
        }
        
        fp = fopen(buf, "w");
        if (fp == NULL) {
        //pc.printf("Unable to write the file\r\n");
        lcd.printf("Unable to write the file");
        } else {
        fprintf(fp, "WAKTU,V1,V2,V3,V4,VTOTAL\n");
        pc.printf("File name: data%d\r\n",number);
        pc.printf("File successfully written!\r\n");
        lcd.cls();
        lcd.printf("File successfully\nwritten!\n");
        lcd.printf("File Name : data%d",number);
        wait(4.0);
        }
        
    //Input Lama Pengujian ===================================================================
        lcd.cls();
        lcd.printf("Lama Pengujian:\n1 = 180 Menit\n2 = 300 Menit\n3 = 480 Menit");
        //pc.printf("Lama Pengujian:\n1 = 180 Menit\n2 = 300 Menit\n3 = 480 Menit");
        wait(1.0);
        
       
    while(p==1)
    {
        if(mybutton1==0)
        {
            lcd.cls();
            jam=180;
            lcd.locate(0, 0);
            lcd.printf("Pengujian 180 Menit\n");
            pc.printf("Pengujian 180 Menit\n");
            wait(1.0);
            z=1;
            p=0;
            break;
        }
        
        if(mybutton2==0)
        {
            lcd.cls();
            jam=300;
            lcd.locate(0, 0);
            lcd.printf("Pengujian 300 Menit\n");
            pc.printf("Pengujian 300 Menit\n");
            wait(1.0);
            z=1;
            p=0;
            break;
        }
        
        if(mybutton3==0)
        {
            lcd.cls();
            jam=480;
            lcd.locate(0, 0);
            lcd.printf("Pengujian 480 Menit\n");
            pc.printf("Pengujian 480 Menit\n");
            wait(1.0);
            z=1;
            p=0;
            break;
        }
    }
    
    //Pengukuran Vopen=================================    
    lcd.cls();
    lcd.printf("Tekan 1 Untuk V Open\n");
    pc.printf("Tekan 1 Untuk VOPEN\n");
    wait(1.0);
        
    while(z==1)
    {
        V1 = V1_VALUE.read(); 
        V1 = (V1 * 3300*x1)/n; 
    
        V2 = V2_VALUE.read(); 
        V2 = ((V2 * 3300)*x2)/n;
        V2 = V2-V1; 
        
        V3 = V3_VALUE.read(); 
        V3 = ((V3 * 3300)*x3)/n;
        V3 = V3-V1-V2;

        V4 = V4_VALUE.read(); 
        V4 = ((V4 * 3300)*x4)/n;
        V4 = V4-V1-V2-V3;

        VTOTAL=V1+V2+V3+V4;

        if(mybutton1==0)
        {   
            fprintf(fp,"V Open,%.1f V,%.1f V,%.1f V,%.1fV,%.1f\r\n",V1,V2,V3,V4,VTOTAL);
            lcd.locate(0, 1);
            lcd.printf("V Open Telah Diukur");
            //lcd.locate(1, 2);
            //lcd.printf("Has been measured");
            pc.printf("\nVOPEN : Volt V1 = %.1f V, Volt V2 = %.1f V, Volt V3 = %.1f V, Volt V4 = %.1fV VTOTAL=%.1f\r\n",V1,V2,V3,V4,VTOTAL);
            wait(3.0);
            z=0;
            x=1;
            break;
        }
    }    
        
        lcd.cls();
        lcd.printf("Silahkan beri beban\nTekan run untuk mulai");
      //  pc.printf("Silahkan Beri Beban\n\rTekan Run Untuk Mulai\n\r");
        
    while(x==1)
    {
        V1 = V1_VALUE.read(); 
        V1 = (V1 * 3300*x1)/n;
        
        V2 = V2_VALUE.read(); 
        V2 = ((V2 * 3300)*x2)/n;
        V2 = V2-V1; 
        
        V3 = V3_VALUE.read(); 
        V3 = ((V3 * 3300)*x3)/n;
        V3 = V3-V1-V2;

        V4 = V4_VALUE.read(); 
        V4 = ((V4 * 3300)*x4)/n;
        V4 = V4-V1-V2-V3;

        VTOTAL=V1+V2+V3+V4;
        abc1=V1;
        abc2=V2;
        abc3=V3;
        abc4=V4; 
        if(mybutton==0)
        {
            lcd.cls();
            fprintf(fp,"0,%.1f V,%.1f V,%.1f V,%.1fV,%.1f\r\n",V1,V2,V3,V4,VTOTAL);
            lcd.printf("Pengujian Dimulai\n");
            //pc.printf("0,Volt V1 = %.2f V, Volt V2 = %.2f V, Volt V3 = %.2f V, Volt V4 = %.2fV VTOTAL=%.2f\r\n",V1,V2,V3,V4,VTOTAL);
            wait(1.0);
            c=1;
            x=0;
            break;
        }
    }
        //Timer Start
            t.start();
            t1.start();
            t2.start();
            t3.start();
            t4.start();
                    
            
    float Vsat=10.80; 
    int n=1000;
    int k=1;
    
    ulang:       
    while(c==1)
    {    
        lcd.cls();
        d=t.read();
        d1=t1.read();
        d2=t2.read();
        d3=t3.read();
        d4=t4.read();   
        
        if(d==59)
        {
            t.reset();
            m=m+1;

        }
        if(d1==59)
        {
            t1.reset();
            m1=m1+1;

        }
        if(d2==59)
        {
            t2.reset();
            m2=m2+1;

        }
        if(d3==59)
        {
            t3.reset();
            m3=m3+1;

        }

        //Volt 4 Battery
        V1 = V1_VALUE.read(); 
        V1 = (V1 * 3300*x1)/n; 
        jum1 += V1;
        
        V2 = V2_VALUE.read(); 
        V2 = ((V2 * 3300)*x2)/n;
        V2 = V2-V1; 
        jum2 += V2;
        
        V3 = V3_VALUE.read(); 
        V3 = ((V3 * 3300)*x3)/n;
        V3 = V3-V1-V2;
        jum3 += V3;

        V4 = V4_VALUE.read(); 
        V4 = ((V4 * 3300)*x4)/n;
        V4 = V4-V1-V2-V3;
        jum4 += V4;
        
        count++;
        
        
        stat=((m*100)/jam);
        stat1=((m1*100)/jam);
        stat2=((m2*100)/jam);
        stat3=((m3*100)/jam);
        
            lcd.cls();
            if(abc1<=Vsat)
            {
                lcd.locate(10, 0);
                lcd.printf("C1=%.1f",stat);
                lcd.locate(19, 0);
                lcd.printf("%");
                t.stop(); 
            }
            if(abc2<=Vsat)
            {
                lcd.locate(10, 1);
                lcd.printf("C2=%.1f",stat1);
                t1.stop();
            }
            if(abc3<=Vsat)
            {       
                lcd.locate(10, 2);
                lcd.printf("C3=%.1f",stat2);
                t2.stop();
            }          
            if(abc4<=Vsat)
            {
                lcd.locate(10, 3);
                lcd.printf("C4=%.1f",stat3);
                t3.stop();
            }
            
            if((abc4<=Vsat)||(abc3<=Vsat)||(abc2<=Vsat)||(abc1<Vsat))
            {
                led=!led;
            }
            else
            {
                lcd.locate(9, 0);
                lcd.printf("Time:%.0d:%.0f",d3,m3);
                led=0;
            }
            
            while (count == max){
                
                jum1/=max;
                jum2/=max;
                jum3/=max;
                jum4/=max;
                VTOTAL = jum1+jum2+jum3+jum4;
                
                abc1=jum1;
                abc2=jum2;
                abc3=jum3;
                abc4=jum4;
                
                jum1 = 0;
                jum2 = 0;
                jum3 = 0;
                jum4 = 0;
                count = 0;
                
                goto ulang;
                
        }
            lcd.locate(0, 0);
            lcd.printf("V1=%.1fV",abc1);
            lcd.locate(0, 1);
            lcd.printf("V2=%.1fV",abc2);
            lcd.locate(0, 2);
            lcd.printf("V3=%.1fV",abc3);
            lcd.locate(0, 3);
            lcd.printf("V4=%.1fV",abc4);
            wait(1.0);
            
            if (((abc4<=Vsat)||(abc3<=Vsat)||(abc2<=Vsat)||(abc1<=Vsat))&&(k==1)){
                fprintf(fp,"%.0f,%.1f V,%.1f V,%.1f V,%.1fV,%.1f\r\n",m,abc1,abc2,abc3,abc4,VTOTAL);
                k=0;
                }
                
            if (d4>898){
                fprintf(fp,"%.0f,%.1f V,%.1f V,%.1f V,%.1fV,%.1f\r\n",m,abc1,abc2,abc3,abc4,VTOTAL);
                //pc.printf("%.0f,Volt V1 = %.2f V, Volt V2 = %.2f V, Volt V3 = %.2f V, Volt V4 = %.2fV VTOTAL=%.2f\r\n",m,V1,V2,V3,V4,VTOTAL);
                t4.reset();
            }
            
            if (mybutton==0){
                c=0;
                led=0;
                fprintf(fp,"%.0f,%.1f V,%.1f V,%.1f V,%.1fV,%.1f\r\n",m,abc1,abc2,abc3,abc4,VTOTAL);
                break;
            }
        }
        
    fclose(fp);
    lcd.cls();
    lcd.printf("  Pengujian Selesai");
    //pc.printf("Pengujian Selsai");
    wait(2.0);
    goto restart;
}
