/////////////////////////////////////////////////////////////////////////
// AMU - Aix-Marseille Université
// Polytech Marseille - Microelectronique & Telecommunications (MT)
// Projet MT5A "STM32 In the Sky - HAB", 2018-2019
// Enseignants : C.Dufaza & H. Aziza
// Etudiants : ...
/////////////////////////////////////////////////////////////////////////
// Version avril 2019, C.Dufaza

/////////////////////////////////////////////////////////////////////////
// Activation des différents modules de ce code (via directives de compilation)
// Permet de désactiver rapidement la compilation de certaines parties du code
// Commentez les lignes pour désactiver les modules/fonctionnalités :

#define DEBUG_SERIAL_PC 1       // Debug sur Serial PC COM Port
#define DEBUG_SERIAL_PC_BAUDRATE 115200
//#define BUZZ_FUNCTION 1         // Buzzer
#define BUZZ_FUNCTION_DURATION 1500 // Nbre de périodes du buzzer
#define BUZZ_FUNCTION_HZ 333    // 1/2 Période de la Hz buzzer (en us)

#define SD_GPRS_DATA_SIZE 150   // Chaine car pour SD et SMS

#define HAB_FUNCTION 1          // HAB Ticker
#define TICKER_HAB_TIME 5.0     // HAB Ticker toutes les ... secondes
#define BASE_PRESSURE 1016      // Pression du jour, altitude = 0 

#define SD_FUNCTION 1           // Carte SD
#define SD_FUNCTION_SDNAME "sd" // Nom de la carte SD
#define SD_FUNCTION_FILENAME "/sd/data.txt" // Nom du fichier sur carte SD
#define SD_FUNCTION_TESTFILENAME "/sd/sdtest.txt" // Nom du fichier sur carte SD

#define MP3_FUNCTION 1          // Module lecteur MP3

#define GSM_FUNCTION 1          // Module GSM
#define TICKER_CHECK_GSM_TIME 60.0 // GSM Ticker toutes les ... secondes
#define GSM_BAUDRATE    9600
#define GSM_SIM_NUMBER  "0758897561" // SIM mobile number
#define GSM_START_ALTITUDE 5000  // Vérification du GSM à partir de 5Km pendant en attérissage 

#define GPRS_FUNCTION 1         // Données mobiles
#define SMS_FUNCTION 1          // SMS de données toute les 10 min
#define TICKER_SMS_DATA_TIME 6000.0 // SMS Ticket toutes les ... secondes

#define POLYTECH_SERVER "http://147.94.16.160/etudiantmt/index.php?message="
#define GSM_SEND_NUMBER "+33676040268" // SMS to this phone number
#define GSM_SEND_SMS_HELLO "AMU - Polytech Marseille MT - STM32 In the Sky" // SMS Welcome Message
//
#define GPS_FUNCTION 1          // Module GPS
//#define GPS_DEBUG               // Transmission des données serie GPS sur UART
#define GPS_BAUDRATE    9600
//

#define XNUCLEO_FUNCTION 1      // Shield capteurs XNUCLEO
#define PT100_FUNCTION 1        // Module PT100
//#define DS18_FUNCTION         // Capteur temperature DS18
#define UV_FUNCTION 1           // Capteur UV
#define PHOTORES_FUNCTION 1     // Capteur photoresistance
#define BOSCH_FUNCTION 1        // Module triple capteur Bosch
#define CO2_FUNCTION 1          // Module CO2
#define O3_FUNCTION 1           // Module spi_ozone O3

/*
#define LORA_FUNCTION 1         // Carte LoRa, not used !!
#define LORA_FUNCTION_BAUDRATE 9600
#define LORA_FUNCTION_DATASIZE 50
*/
