#include "mbed.h"
#include "tsi_sensor.h"

/* aca se define el tsi */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

#include "MMA8451Q.h"

/*CONFIGURACION DEL ACELEROMETRO*/
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

#include "mbed.h"
#include <time.h>       /* time */

#define TICK_MS   10  //constante para configurar ticker
#define LED_T_ON_MS  300  //constante para tiempo on en ms
#define LED_T_OFF_MS  1000  //constante para tiempo off en ms
#define TO_LED_OFF_MS  LED_T_OFF_MS / TICK_MS
#define TO_LED_ON_MS   LED_T_ON_MS / TICK_MS
#define APAGADO 1
#define ENCENDIDO 0
#define NO 0
#define SI 1


enum {LED_ON, LED_OFF};
Ticker TICK; 
Ticker tsi_ticker; //lee el tsi cada 100ms
DigitalOut LED(LED_RED);
int CAMBIAR_ESTADO = NO;
unsigned int LED_tout = 0; //contador del tiempo del led, cada 0,05s se incrementa
char LED_estado = LED_ON;
char HABILITACION = NO; 
void LED_MAQ(); 
void LED_TICK();
void iniciacion(); //inicia hardware
void recibir_datos(); 
void TRAMA_RECIBIR(); 
void calcularVerificacion(int xg); //xg es valor de variable en cuestion
char c; //guarda valor en c 
bool newdata = false; //cuando llega un nuevo valor al micro , lo pone en true y despues se vuelve a desactivar

enum {INICIO, VARIABLE, FIN}; 
char estado_recibir = INICIO; 

unsigned char verificacionFinal[2]; //vector del valor de la verificacion 
char trama_recibir[3]; // guarda byte que le van llegando
RawSerial pc(USBTX, USBRX); //config puerto serie
TSIAnalogSlider tsi(ELEC0, ELEC1, 40); //comando para configurar el tsi 
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); //acelerometro

DigitalIn entradaDigital(PTD3); 

AnalogIn entradaAnalogica(PTB0);

int x, y, z; //ejes acelerometro
void LED_TICK() //maquina de estados del parapdeo del led
{
    switch(HABILITACION) { 
        case NO: //deshabilitacion led
            if(LED_tout == 5) { //si led tout es 5 cambia estado del led, lo invierte. esta funcion se corre cada 50ms . 5x50 = 250ms, quq es lo que tiene que tardar en hacerse el parpadeo. 
                CAMBIAR_ESTADO = SI;
                LED_tout = 0; 
            }
            LED_tout++; //incrementa todo el tiempo . llega hasta 5 y vuelve a 0 y asi constantemente
            break;

        case SI:
            if(LED_tout == 6) { //cuenta, cuando el valor es 6, cambia estado, es decir, lo invierte, porque pasaron 300ms . 6x50=300ms
                CAMBIAR_ESTADO = SI;
            }
            if(LED_tout == 12) {
                CAMBIAR_ESTADO = SI;
            }
            if(LED_tout == 18) { 
                CAMBIAR_ESTADO = SI;
            }
            if(LED_tout == 38) { // aca es un segundo que tiene que estar apagado  20x50= 1000ms = 1seg. 
                CAMBIAR_ESTADO = SI;
                LED_tout = 0;
            }
            LED_tout++; 
            break;
    }
}
void TSI_READ()
{
    float tsiRead = tsi.readPercentage(); //lee el valor del TSI
    if(tsiRead > 0.05) { 
        if(HABILITACION == SI) { // si esta habilitado lo deshabilita
            LED_tout = 0; //resetea todos los valores cuando detecta pulso 
            tsiRead = 0; 
            LED_estado = LED_ON;
            HABILITACION = NO;
            
        } else if(HABILITACION == NO) { // si esta deshabilitado lo habilita
            LED_tout = 0;  
            tsiRead = 0;
            LED_estado = LED_ON;
            HABILITACION = SI;
            
        }
    }

    x = float(abs(acc.getAccX()) * 255); //lee valor eje x acelerometro 
    if(x > 255) { //cualquier valor mayor a255 lo deja en 255
        x = 255;
    }
    y = float(abs(acc.getAccY()) * 255);
    if(y > 255) {
        y = 255;
    }
    z = float(abs(acc.getAccZ()) * 255);
    if(z > 255) {
        z = 255;
    }
}

void iniciacion()
{
    TICK.attach(&LED_TICK, 0.05); //ticker del led 
    tsi_ticker.attach(&TSI_READ, 0.1); //ticker que permite una buena lectura, sin ruido o atrasos
}


int main()
{
    pc.attach(&recibir_datos);//micro recibe que pc le habla, ejecuta funcion
    iniciacion(); //para que arranque el ticker
    for(;;) {
        LED_MAQ(); 
        if(HABILITACION == SI) { //si habilitacion esta encendida...
            TRAMA_RECIBIR(); //corre trama recibir, que es la funcion de la maquina de estados de protocolo
        }
    }
}

//maquina de estados
void LED_MAQ()
{
    switch(LED_estado) {
        case LED_ON:
            LED = ENCENDIDO;
            if(CAMBIAR_ESTADO == SI) {
                LED_estado = LED_OFF;
                CAMBIAR_ESTADO = NO;
            }
            break;

        case LED_OFF:
            LED = APAGADO;
            if(CAMBIAR_ESTADO == SI) {
                LED_estado = LED_ON;
                CAMBIAR_ESTADO = NO;
            }
            break;
    }
}

void recibir_datos() //guarda los datos en c y activar newdata
{
    c = pc.getc(); //c es valor del dato
    newdata = true; //newdata informa que llego un nuevo valor y hace que trama recibir se ejecute
}

void TRAMA_RECIBIR()
{
    if(newdata) {// si llega un dato nuevo al micro
        newdata = false;//lo pone en falso para que no vuelva a entrar al if hasta que no le llegue otro dato. Si no llega un dato nuevo no vuelva a entrar al if
        switch(estado_recibir) { 
            case INICIO: 
                if(c == '#') {
                    trama_recibir[0] = '#' ; //en trama recibir guardo numeral y la proxima vez hago que estado recibir sea VARIBALE xq ahora espero el byte que me indica que varible me van a pedir. todo esto se identifica en el estado VARIABLE
                    estado_recibir = VARIABLE;
                }
                break;
            case VARIABLE: 
                if(c == 'X') { //variable x, guarda trama
                    trama_recibir[1] = c; //c = x, gguarda caracter en el segundo lugar
                    estado_recibir = FIN; 
                } else if(c == 'Y') { //variable y
                    trama_recibir[1] = c;
                    estado_recibir = FIN;
                } else if(c == 'Z') { //variable z
                    trama_recibir[1] = c;
                    estado_recibir = FIN;
                } else if(c == 'V') { //variable analogica
                    trama_recibir[1] = c;
                    estado_recibir = FIN;
                } else if(c == 'D') { //variable digital
                    trama_recibir[1] = c;
                    estado_recibir = FIN;
                } else if(c == '#') { 
                    trama_recibir[0] = c; // lo reescribe 
                    estado_recibir = VARIABLE;
                } else { //volver a empezar, si no fue ninguna de las anteriores te manda al inciio a esperar de nuevo ya que fue un error
                    estado_recibir = INICIO;
                }
                break;
            case FIN:
                if(c == ')') {
                    estado_recibir = INICIO; //empieza una trama nueva ya que el proxima byte tiene que ser un byte de comienzo
                    trama_recibir[2] = ')'; //guarda el ultimo valor
                    if(trama_recibir[1] == 'X') { //si metiste la X , pediste valor acelerometro
                        int xc=0, xd=0, xu=0; //separo centenas decenas unidades que llega hasta 255
                        xc = x / 100; //centenas
                        xd = (x - xc * 100) / 10; //decenas
                        xu = (x - xc * 100 - xd * 10); //unidades
                        
                        calcularVerificacion(x); //corre funcion que calculo la verifiacion 
                        
                        pc.putc('#'); 
                        pc.putc('X'); 
                        pc.putc(xc + 48); // EL +48 lo que hace es pasarte la centena a ASCII 
                        pc.putc(xd + 48); 
                        pc.putc(xu + 48);  
                        pc.putc(verificacionFinal[0]); // cuando corres verificacion te guarda en un char el valor entre 0 y F, en posicion 0 las decenas
                        pc.putc(verificacionFinal[1]); // lo mismo pero en posicion 1 las unidades
                        pc.putc(')');  
                        //enviar dato X
                    } else if(trama_recibir[1] == 'Y') {
                        
                        int yc=0, yd=0, yu=0;
                        yc = y / 100;
                        yd = (y - yc * 100) / 10;
                        yu = (y - yc * 100 - yd * 10);
                        
                        calcularVerificacion(y);
                        
                        pc.putc('#');
                        pc.putc('Y');
                        pc.putc(yc + 48);
                        pc.putc(yd + 48);
                        pc.putc(yu + 48);
                        pc.putc(verificacionFinal[0]);
                        pc.putc(verificacionFinal[1]);
                        pc.putc(')');
                        estado_recibir = INICIO;
                        //enviar dato Y
                    } else if(trama_recibir[1] == 'Z') {
                        
                        int zc=0, zd=0, zu=0;
                        zc = z / 100;
                        zd = (z - zc * 100) / 10;
                        zu = (z - zc * 100 - zd * 10);
                        
                        calcularVerificacion(y);
                        
                        pc.putc('#');
                        pc.putc('Z');
                        pc.putc(zc + 48);
                        pc.putc(zd + 48);
                        pc.putc(zu + 48);
                        pc.putc(verificacionFinal[0]);
                        pc.putc(verificacionFinal[1]);
                        pc.putc(')');
                        estado_recibir = INICIO;
                        //enviar dato Z
                    } else if(trama_recibir[1] == 'V') {
                        float pf = entradaAnalogica; //numero con coma
                        int p = pf*255; //desaparece el numero con coma 
                        
                        if(p > 255){ //para que no pase de 255
                            p = 255;
                        }
                         
                        int pce = p / 100; 
                        int pd = ( p - pce * 100) / 10; 
                        int pu =  p - ( pce * 100) - pd * 10; 
                        
                        calcularVerificacion(p); 
                        
                        pc.putc('#');
                        pc.putc('V');
                        pc.putc(pce + 48);
                        pc.putc(pd + 48);
                        pc.putc(pu + 48);
                        pc.putc(verificacionFinal[0]);
                        pc.putc(verificacionFinal[1]);
                        pc.putc(')');
                        estado_recibir = INICIO;
                        //enviar dato analogico
                    } else if(trama_recibir[1] == 'D') {
                        
                        int d = entradaDigital; //1 o 0
                        calcularVerificacion(d); //mando valor a calcular verificacion 
                        
                        pc.putc('#');
                        pc.putc('D');
                        pc.putc('0'); //centena siemore 0 en valor digital
                        pc.putc('0'); //decena siempre 0 en valor digital
                        pc.putc(d + 48);
                        pc.putc(verificacionFinal[0]); //pone decena de verificaion
                        pc.putc(verificacionFinal[1]); // pone unidad de verificacion
                        pc.putc(')');
                        estado_recibir = INICIO;
                        //enviar dato digital
                    }
                }else if(c == '#') { //empieza de nuevo ya que hubo un error
                    trama_recibir[0] = c; //si hay error , lo reescribe 
                    estado_recibir = VARIABLE;
                }
                 else {
                    estado_recibir = INICIO; //si no me mandaron caracter de final voy a inicio. 
                }
                break;

        }
    }
}

void calcularVerificacion(int xg) //calcula verificacion mandando a xg el valor de la variable en cuestion, entre 0 y 255 o 0 y 1
{
    int xc=0, xd=0, xu=0; //separo gx en centena decena unidad
    xc = xg / 100;
    xd = (xg - xc * 100) / 10;
    xu = (xg - xc * 100 - xd * 10);
    
    int verificar = trama_recibir[1] + xc + xd + xu + 48 + 48 + 48; //xc xd xu son varibles entre 0 y 1. suma 3 veces 48 porque es una por cada uno 
    
    int verificarFinal = 255 - verificar + 1; //si 255 es maximo valor. verificar es en decimales la suma de las cuatro variabales del ASCII de cada una (B068, por ejemplo). 
    
    int verificarPd = verificarFinal / 16; //La respuesta de KL a PC es en hexa. Paso decenas a hexa
    int verificarPu = verificarFinal - (verificarPd * 16); // paso unidades a hexa
    if(verificarPu > 9) { //para unidades
        switch(verificarPu) {
            case 10: //el hercules en lugar de mostrar 10, te muestra A y a asi hasta F
                verificacionFinal[1] ='A';
                break;
            case 11:
                verificacionFinal[1] ='B';
                break;
            case 12:
                verificacionFinal[1] ='C';
                break;
            case 13:
                verificacionFinal[1] ='D';
                break;
            case 14:
                verificacionFinal[1] ='E';
                break;
            case 15:
                verificacionFinal[1] ='F';
                break;
        }
    } else {
        verificacionFinal[1] = verificarPu + 48; //numero entre 0 y 9 , te manda el numero ASCII y x eso le sumas 48.
    }

    if(verificarPd > 9) { 
        switch(verificarPd) {
            case 10:
                verificacionFinal[0] ='A';
                break;
            case 11:
                verificacionFinal[0] ='B';
                break;
            case 12:
                verificacionFinal[0] ='C';
                break;
            case 13:
                verificacionFinal[0] ='D';
                break;
            case 14:
                verificacionFinal[0] ='E';
                break;
            case 15:
                verificacionFinal[0] ='F';
                break;
        }
    } else {
        verificacionFinal[0] = verificarPd + 48;
    }
}