#include "mbed.h"
#include "m3pi.h"

// Quick test for a pair of Pololu Wixels, both configured with Wireless Serial App (download from Pololu)

// m3pi Robot is used as a convenient dev board, since it has a socket for a Wixel already, and connects
// to the Wixel on pins 28/27/26 (Tx/Rx/nReset).

// Note the nReset is optional, and the code works without it (thanks to internal pullup resistors).
// However, don't declare p26 as a Digital output unless you plan to use it as the Wixel nReset, in which case
// you need to drive it high to bring the Wixel out of reset.

m3pi m3pi;
Serial Wixel(p28, p27); // tx, rx
Serial PC(USBTX, USBRX);
//DigitalOut Wixel_nReset(p26); // don't declare unless you want nReset capability

int main()
{
  m3pi.locate(0,0);
  m3pi.printf("Wixel!"); // need to send something to the m3pi just to stop it running the demo app...
  //Wixel_nReset = 1; // take the Wixel out of reset
  Wixel.baud(9600); // Wixel default baud rate (can configure other rates via Wixel config app...)
  while(1)
  {
    Wixel.printf("Hello Wixel\r\n");
    while (Wixel.readable())
    {
      PC.putc(Wixel.getc());
    }
    wait_ms(1000);
  }
}
