#include "mbed.h"
 
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut mP22(p22);
Serial pc(USBTX, USBRX); // tx, rx

float LastPosition =0.02;
volatile float Scale = 1;
volatile float Multiplier = 100;
volatile float offset = 1000;
volatile char SetScale;// =0;
volatile char SetMultiplier;//=0;
    
void SerialPC_RX_CB() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    char RXchar = pc.getc();
    
    if(SetScale == 1)
     {
        if( (RXchar > '0') && (RXchar <= '9'))
        {
            SetScale =0;
            Scale = (RXchar - '0');
            pc.printf("Scale Set\r\n");
        }
        else pc.printf("Scale values must be 0-9");
     }
     
    else
    if(SetMultiplier == 1)
     {
        if( (RXchar > '0') && (RXchar <= '9'))
        {
            SetMultiplier =0;
            Multiplier =1;
            for(int i =0;i < (RXchar - '0'); i++)
                Multiplier*=10;
            pc.printf("Multiplier Set to %f\r\n",Multiplier);
        }
        else {
        pc.printf("Multiplier values must be 0-3 representing zeroes");
        }
     }
      
    else
    if((RXchar > 0x29) && (RXchar < 0x40)){
        float Delta = ((float)( RXchar - '0'));
        Delta = (Delta*Scale * Multiplier)+offset;
        mP22.pulsewidth_us(Delta);
        pc.printf("Pulse Width Changed to : %f \r\n",Delta);
        
        }
        
     else
     if(RXchar == 's')
     {
        SetScale = 1;
     }
     if(RXchar == 'm')
     {
        SetMultiplier =1;
     }

     //else{ if(RXchar == 'm') mP22 = 0.01;
      //          else if(RXchar == 'u') mP22 = 1.2;
     //          }

}
 
int main() {

    pc.attach(&SerialPC_RX_CB);
    
    mP22 = LastPosition;
    SetScale = 0;
    SetMultiplier = 0;
    
    pc.printf("Set Scale/Offset with (s/o)\r\nEnter a number from 0-9 \r\n");

    while(1)
    {
        if (SetScale == 1)
            {
                pc.printf("Change the Scale Factor according to P(x) = Offset + (Scale* Multiplier * x) \r\n");
                while(SetScale == 1){
                    led2 = !led2;
                    wait(100);
                    }
                    
                    led2 = 0;
                //wait(100);
                pc.printf("Set Scale/Offset with (s/o)\r\nEnter a number from 0-9 \r\n");
            }
        else if(SetMultiplier ==1)
        {
                pc.printf("Change the Multiplier according to P(x) = Offset + (Scale* Multiplier * x) \r\n");
                while(SetMultiplier == 1){
                    led1 = !led1;
                    wait(100);
                }
                led1 = 0;
                //wait(100);
                pc.printf("Set Scale/Offset with (s/o)\r\nEnter a number from 0-9 \r\n");
        }
        
    }
    
}
 
