#include "mbed.h"
#include <math.h>
#include <stdio.h>
#include "Sentral.h"
#include "Test_Routines.h"

Timeout escapez;

int timeoutz=0;


extern DigitalOut SA0;

typedef char* string;

#define PI 3.14159f

PwmOut g(LED_GREEN);
PwmOut r(LED_RED);
PwmOut b(LED_BLUE);

Serial pc(USBTX,USBRX);
I2C master(PTC9,PTC8);

AnalogIn VDD_Check(PTE30);

DigitalIn POWER(PTE29);

void VDD_read_request()     {pc.printf("[*Moudle Voltage: %f *] \r\n",(VDD_Check.read()*3.3f));}


    
void find_sentral(){
    char inbuff[2],obuff[2];
    obuff[0] = 0x37;
    int check[2];
    int addr = SA0 ? AddrSA0_hi : SENTRAL_ADDRESS;
    escapez.attach(&timeit, 10.0);
    pc.printf("Check1\n");
    check[0] = master.write(addr, obuff, 1);
    
    pc.printf("Check2\n");
    check[1] = master.read(addr, inbuff, 1);
    pc.printf("finding sentral... \r\nwrite %s \r\n",check[0] ? "Fail" : "Pass" );
    
    pc.printf("read %s \r\n reading back: %X \r\n",check[1] ? "Fail" : "Pass" , inbuff[0]);
//continue_z:

    if(!check[0] && !check[1]){
    pc.printf("[*{01}Sentral Status: \r\n");
    pc.printf("NEEPROM:   %d \r\n", (int)((inbuff[0] & 16)>0));
    pc.printf("StbyState: %d \r\n", (int)((inbuff[0] & 8)>0));
    pc.printf("UploadErr: %d \r\n", (int)((inbuff[0] & 4)>0));
    pc.printf("UploadCPT: %d \r\n", (int)((inbuff[0] & 2)>0));
    pc.printf("EEPROMDTC: %d*] \r\n", (int)((inbuff[0] & 1)>0));}
    

    
    else pc.printf("[*{00}No Sentral Detected*]");
    escapez.detach();
    //pc.printf("Sentral Status: %X",cmd[0]);
}

void timeitz()
{
    master.stop();
    //goto continue_z;
    //timeoutz =1;
    }


    
void RX_int_cb();

int main() {
    
    wait(2);
    //RST =0;
    pc.attach(&RX_int_cb);
    pc.baud(115200);
    pc.printf("\nEV0 Test Fixture v1.0\n");
    
    r.period(0.020);
    g.period(0.020);
    b.period(0.020);
    
    r = 0.990;
    b = 0.950;
    g = 0.895;
    
    
    SA0_init();
    
    pc.printf("SAO Set to %d \r\n",Set_SA0());
    Sentral_Power(0);
    wait(0.01);
    //VDD_read_request();
    Sentral_Power();
    pc.printf("Sentral Powered on\r\n");
    
    //VDD_read_request();
    
    //find_sentral();
    
   // SentralSetup();
    
    //VDD_read_request();
    
    while (true){
        
        if(POWER==0)
        {
            //pc.printf("bus init\n");
            //BusOut GPIOS(PTE4,PTE3,PTE2,PTB11,PTB10,PTB9,PTB8);
            //pc.printf("i2c remap\n");
            //DigitalOut x(PTC9),y(PTC8);
            //pc.printf("delegating\n");
            //x=y=0;
            //GPIOS = 0;
            //pc.printf("SA0\n");
            Set_SA0(0);
            wait_ms(10); 
            pc.attach(NULL);
            while(Sentral_Power(0));
            pc.printf("[*{21}MODULE POWER DISABLED \r\n");
            //VDD_read_request();
            wait_ms(10);
            pc.printf("ENABLE POWER TO CONTINUE*] \r\n");
            while(!POWER);
            while(!Sentral_Power(1));  
            pc.attach(&RX_int_cb);
            pc.printf("[*{20}MODULE POWER ENABLED*] \r\n");
            wait(1);
            VDD_read_request();
            
        }
        
    }
}


void RX_int_cb() {
    
    switch(pc.getc()) {
        
        case 'r':
        VDD_read_request();
        break;
        /*
        case 'l':
        if(reading){
            if(!hex_read_line(FILE *hexfile)){
                reading =0;
                pc.printf("EOF\r\n");}
                }else pc.printf("no file open\r\n");
        break;
        
        case 'h':
        if(reading)
        {
            readhex = 1;
            
            }
            break;
            */
        case 'f':
            find_sentral();
            break;
            
        case 's':
            pc.printf("Sentral Starting up. \r\n");
            //find_sentral();
            if(!SentralSetup(pc,master))
                //pc.printf("returning to loop\r\n");
                //else 
                pc.printf("Sentral Start exit failure\r\n");
            break;
            
        case 't':
             pc.printf("Begginng module test...\r\n");
            // pc.printf("Sentral Starting up. \r\n");
            //find_sentral();
    //if(!SentralSetup(pc,master))
        //pc.printf("returning to loop\r\n");
        //else 
        //pc.printf("Sentral exit failure\r\n");
      //  return 0;
        //}   
        //else
            if(EV0_test(pc,master)) pc.printf("[*{11}Module PASS*] \r\n");
            break;
            
        //case '!':
        //    DigitalOut RST(PTE5);
        //    RST =0;
        //    break;
        
        case '0':
            int i = SA0;
            pc.printf("SA0: %d",i);
            break;
            
        case 'p':
            pc.printf(/*Sentral_pass_through(pc,master)*/ PassThroughTest(pc,master) ? "Passthrough enabled \r\n" : "Passthrough Failure \r\n");
            break;
            
        default:
        pc.printf("[*undefined command*] \r\n");
        break;
        }
    
    }
    
    