//STM32 Tracler ports
#include "mbed.h"

#define SENTRAL_DI02

#define TRUE    1
#define FALSE   !TRUE

#include "Sentral.h"

DigitalOut SentralPower(PTA5);
DigitalOut SA0(PTA4);

void SA0_init()
{
   // SA0.mode(PullDown);
   Set_SA0(0);  
}

int Set_SA0(int val){
    
    SA0 = (val > 0);
    return SA0;   
}

int Sentral_Power(int val){
    
    SentralPower = (val > 0);
    return SentralPower;
}

void Sentral_Reset(){
    
    Sentral_Power(0);
    wait(1);
    Sentral_Power(1);
    
}
int Sentral_pass_through(Serial &pc,I2C &master,int recursion)
{
    if(recursion > 20)
    {
        pc.printf("Recursion limit reached \r\n");
        return 0;
     }
        
    char cmd[3];
    char chk[3];
    
  
    //Serial_PutString("Sentral Reset Reg", 20);
    cmd[0] = PASSTHROUGH_CONFIG_REG;
    cmd[1]=0x01;
    int check = master.write(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS,cmd,2); 
  
    //cmd[0] = 0;
  
    if(check)
        pc.printf("Pass through request fail, I2C write fail \r\n",check);
    else
    {
        check = master.write(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS,cmd,1);
        check = master.read(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS,chk,1);
        
        if(check)
            pc.printf("Pass through register read fail. \r\n");
        else
        {
            if(chk[0] == 0x01)
            {
                pc.printf("Pass through Success \r\n");
                return 1;
            }
            else
            {
                pc.printf("Recursion %d failed \r\n", recursion);
                return Sentral_pass_through(pc,master,++recursion);
            }
        }
        
        
        
    }  
}


//I2C master(p28, p27);
//Serial pc(USBTX,USBRX);


/*******************************************************************************
* Function Name  : SentralSetup
* Description    : code snippet for setting up sentral
*                  to run.
* Return         : None
*******************************************************************************/ 
unsigned int SentralSetup(Serial &pc,I2C &master){
  

  Sentral_Reset();
  pc.printf("Reset");
  
  unsigned char /*temp[1],*/boot_timeout=0,count=0x00;
  //unsigned char test = 0, ReturnedByte=0x00;
  //int ret_status= 0x00;  
  
  char cmd[10];
    
  
  //Serial_PutString("Sentral Reset Reg", 20);
  cmd[0] = RESET_REQ_REG;
  cmd[1]=0x01;
  int check = master.write(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS,cmd,2); 
  
  cmd[0] = 0;
  
  if(check)
    pc.printf("I2C Reset Request Fail, Check pull-ups and Reset \r\n",check);
  else
    pc.printf("Reset Request Pass \r\n");
  
  pc.printf("Status Check: ");
  //while(((ReturnedByte & 0x06) != 2)&&(boot_timeout==0)){
  while(((cmd[0] & 0x06) != 2)&&(boot_timeout==0)){
    
    //test=SentralRead(SENTRAL_STATUS_REG,&ReturnedByte);
    cmd[0] = SENTRAL_STATUS_REG;
    //cmd[1]= 0x01;
    check = master.write(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS, cmd, 1);
    if(check)
        pc.printf("i2c write fail %d \r\n",check);
    cmd[0] = 0;
    master.read(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS, cmd, 1);
    if(check)
        pc.printf("i2c read fail %d \r\n",check);
    
    //pc.printf(" %d,%X",count,cmd[0]);
    
    count++;
    if(count==30)
      boot_timeout=1;
    
    wait_ms(100);
    
  }
  if(check)
        pc.printf("[*I2C Bus Failure, try repositioning the module*] \r\n",check);
  
  if(boot_timeout){
     //PrintChars("Timeout occured, sentral not present or took too long to boot from the EEPROM\n\r");
    pc.printf("Timeout occured, sentral not present or took too long to boot from the EEPROM\n\r");

     //SerialPutChars("ReturnByte: 0x");
     pc.printf("Timeout ReturnByte: %X \r\n", cmd[0]);
     //char testbuff[5];
     //snprintf(testbuff, 5, "%x,", ReturnedByte);
     //SerialPutString(testbuff,5);
     //SerialPutChars("Force it");
     //SerialPutChar('\n');
     //SerialPutChar('\r');

    return RETURN_FAILURE;
  }

    pc.printf("Success ReturnByte: %X \r\n", cmd[0]);
    // SerialPutChars("ReturnByte: 0x");
    // char testbuff[5];
    // snprintf(testbuff, 5, "%x,", ReturnedByte);
    // SerialPutString(testbuff,5);
    // //SerialPutChars("Force it");
    // SerialPutChar('\n');
    // SerialPutChar('\r');
     
      //force a times out after 3 seconds
     //count = 0;
     //boot_timeout = FALSE;
      //while(boot_timeout==FALSE){
      //count++;
      //if(count==30)
      //  boot_timeout=TRUE;
      
      wait(1);
    //}

  
  //SentralWrite(ENABLE_EVENTS_REG,0x20); // enable gyro event only (for data logging function)
  //SentralWrite(MAG_RATE_REG,0x64); //set mag rate
  //SentralWrite(ACCEL_RATE_REG,0x0a); //set accel rate
  //SentralWrite(GYRO_RATE_REG,0x46); //set gyro rate
  //SentralWrite(ALGORITHM_CONTROL,0x02); //update registers with RAW sensor data
  //SentralWrite(ALGORITHM_CONTROL,0x00); //update registers with Scaled sensor data
  
  //SentralWrite(HOST_CONTROL_REG,0x01); //Request CPU to run 
  cmd[0] = HOST_CONTROL_REG;
  cmd[1]=0x01;
  master.write(SA0 ? AddrSA0_hi : SENTRAL_ADDRESS,cmd,2); 
  pc.printf("Sentral Startup Success. \r\n");
  
  return 1;
}



