#include "mbed.h"
#include "Sentral.h"
#include "Test_Routines.h"

BusIn GPIOS(PTE4,PTE3,PTE2,PTB11,PTB10,PTB9,PTB8);
Timeout escape;

int timeout=0;

void timeit()
{
    timeout =1;
    }
    
int EV0_test(Serial &pc,I2C &master)
{   

    //Set SA0 to 1
   pc.printf("SA0 set to %d \r\n", Set_SA0(1));
    wait(0.1);
    //Startup Sentral at SA0 = 1;
   if(!SentralSetup(pc,master)){
        pc.printf("[*{10}Sentral Start-up Failure*] SA1 Failed\r\n");
        return 0;
        } 
     int P=0 , trig =0 ;
    //Wait for any pin to fire
    do
        {
        P = GPIOS;
        
        if(P&&0x40)
            trig = 0x40;
        if(P&&0x01)
            trig = 0x01;
        if(P&&0x02)
            trig = 0x02;
        if(P&&0x04)
            trig = 0x04;
        if(P&&0x08)
            trig = 0x08;
        if(P&&0x10)
            trig = 0x10;
        if(P&&0x20)
            trig = 0x20;
        } while((!(GPIOS) && (timeout++ < 1000)));
    
    //Wait for pin to go low again
    while(GPIOS & trig);
        
    if(timeout < 1000)
        pc.printf("Trigger: Pin %d \r\n",trig);
    else
        {
        pc.printf("[*{10}GPIO Timeout*] \r\n");
        return 0;
        }
        
    //reset timeout
    timeout=0;
    
    //Check for simultaneity 
    while( ( GPIOS < 0x7F ) && (timeout < 1000) )
        timeout++;
    
    if(timeout < 100)
        pc.printf("Notice: Pins are simultaneous, check continuity \r\n");
    
    //reset triger and timeout
    timeout=0;
    trig =0;
    
    //start a timer
    escape.attach(&timeit, 10.0);
    
    //wait for each pin to fire**********
    while(!(GPIOS&&0x40))//6
        if(timeout) { trig = -7; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x01))//0
        if(timeout) { trig = -1; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x02))//1
        if(timeout) { trig = -2; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x04))//2
        if(timeout) { trig = -3; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x08))//3
        if(timeout){ trig = -4; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x10))//4
        if(timeout) { trig = -5; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x20))//5
        if(timeout) { trig = -6; break; }
    //END SINGLE PIN TEST
    
    if(!timeout){
        pc.printf("All Pins Fired\r\n");
        //return 1;
        }
    else
    {
        pc.printf("Timeout on %d, [*{10}Test FAILED*] \r\n GPIO Failure at SA0 = 1 \r\n", ( trig * (-1) ) - 1 );
        return 0;
    }
    
    
    //Set SA0 to 0
   pc.printf("SA0 set to %d \r\n", Set_SA0(0));
   wait(0.1);
   //Startup Sentral at SA0 = 0;
   if(!SentralSetup(pc,master)){
        pc.printf("[*{10}Sentral Start-up Failure*] SA0 Failed\r\n");
        return 0;
        }                
    
    //Wait for any pin to fire
    do
        {
        P = GPIOS;
        
        if(P&&0x40)
            trig = 0x40;
        if(P&&0x01)
            trig = 0x01;
        if(P&&0x02)
            trig = 0x02;
        if(P&&0x04)
            trig = 0x04;
        if(P&&0x08)
            trig = 0x08;
        if(P&&0x10)
            trig = 0x10;
        if(P&&0x20)
            trig = 0x20;
        } while((!(GPIOS) && (timeout++ < 1000)));
    
    //Wait for pin to go low again
    while(GPIOS & trig);
        
    if(timeout < 1000)
        pc.printf("Trigger: Pin%d \r\n",trig);
    else
        {
        pc.printf("[*{10}GPIO Timeout*] \r\n");
        return 0;
        }
        
    //reset timeout
    timeout=0;
    
    //Check for simultaneity 
    while( ( GPIOS < 0x7F ) && (timeout < 1000) )
        timeout++;
    
    if(timeout < 100)
        pc.printf("Notice: Pins are simultaneous, check continuity \r\n");
    
    //reset triger and timeout
    timeout=0;
    trig =0;
    
    //start a timer
    escape.attach(&timeit, 10.0);
    
    //wait for each pin to fire**********
    while(!(GPIOS&&0x40))//6
        if(timeout) { trig = -7; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x01))//0
        if(timeout) { trig = -1; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x02))//1
        if(timeout) { trig = -2; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x04))//2
        if(timeout) { trig = -3; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x08))//3
        if(timeout){ trig = -4; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x10))//4
        if(timeout) { trig = -5; break; }
    escape.detach();
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x20))//5
        if(timeout) { trig = -6; break; }
    //END SINGLE PIN TEST
    
    if(!timeout){
        pc.printf("All Pins Fired\r\n");
        //return 1;
        }
    else
    {
        pc.printf("Timeout on %d, [*{10}Test FAILED*] \r\n GPIO Failure at SA0 = 0 \r\n", ( trig * (-1) ) - 1 );
        return 0;
        }
    

    
    
    //FINALLY, Test pass through mode
    
        
    return 1;
    
    
    
}

int PassThroughTest(Serial &pc,I2C &master)
{
    if( !Sentral_pass_through(pc,master) )
    {
        return 0;
    }
    
    char cmd[3];
    char chk[3];
    
    cmd[0] = 0x00;
    cmd[1] = 0x00;
    cmd[2] = 0x00;
    for(int i = 0xA0; i < 0xB0; i += 2)
    {    
        int check = master.write(i,cmd,2);
    
        if(check)
            pc.printf(".");
            //break;//return 0;
        else
        {
            check = master.read(i,chk,3);
    
            if(check)
                pc.printf(".");//break;//return 0;
            else
            {
                pc.printf("\r\n%X,%X,%X \r\n",chk[0],chk[1],chk[2]);
                return 1;
            }
        }
    }
    return 0;    
}

//EOF

