#ifndef __SENTRAL_H
#define __SENTRAL_H

#define SENTRAL_DI02

typedef struct {
  unsigned long AXIS_X;
  unsigned long AXIS_Y;
  unsigned long AXIS_Z;
  unsigned long AXIS_W;
} QuaternionData;

#define SENTRAL_EEPROM_ADDRESS 0xa0
#define SENTRAL_ADDRESS 0x50
#define SENTRAL_ACC_ADDRESS 0x1a
#define SENTRAL_Q_ADDRESS 0x00

void Setup_Sentral_EEPROM();
int SentralGetQData(QuaternionData* buff);

#define SentralAddress 0x50


#ifdef SENTRAL_DI02
#define RETURN_SUCCESS 1
#define RETURN_FAILURE 0
#define ENABLE_EVENTS_REG 0x33
#define MAG_RATE_REG 0x55
#define ACCEL_RATE_REG 0x56
#define GYRO_RATE_REG 0x57
#define HOST_CONTROL_REG 0x34
#define SENTRAL_STATUS_REG 0x37
#define PASSTHROUGH_CONFIG_REG 0xa0
#define RESET_REQ_REG 0x9b
#define REVISION_ID_REG 0x91
#define HOST_STATUS_REG 0x92
#define ALGORITHM_CONTROL 0x54

#define DEFAULT_I2C_SPEED_KHZ 100

//M_BED PORTS
//int ResetSentral(UInt8 NewByte);
//int Setup_Sentral(void); 
unsigned int SentralSetup(Serial &pc,I2C &master);

//M_BED ROUTINES
#define AddrSA0_hi     0x52
int Sentral_Power(int val =1);
int Set_SA0(int val =0);
void Sentral_Reset();
void SA0_init();
int Sentral_pass_through(Serial &pc,I2C &master, int recursion =0);




#endif

#endif