#include "mbed.h"
#include <stdio.h>
#include "Sentral.h"
#include "Test_Routines.h"

#define EV_ALT 1

typedef char* string;

AnalogIn VDD_Check(p15);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

DigitalIn POWER(p22);

#ifdef EV_ALT
#if EV_ALT
I2C master(p9,p10);
#else
I2C master(p28, p27);
I2CSlave slave(p9,p10);
#endif
#endif

Serial pc(USBTX,USBRX);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

void RX_int_cb();

void VDD_read_request();

void find_PROM(I2C i2c,int &address);
int hex_read_line(FILE *hexfile);
char ascii_hex2byte(char* ascii);

int EEPROM_ADDR;
int reading,readhex;

void find_sentral();
//void sentral_startup();

    
int main() {
    

    Set_SA0();
    Sentral_Power(0);
    led1 =0;
    led2 =0.25;
    led3 =0.5;
    led4 =0.75;
    
    pc.attach(&RX_int_cb);
    pc.baud(115200);
    pc.printf("Hello, press 't' to test a module \r\n");
    
    reading =1;
    readhex=0;
    
    
    
    
    
    //pc.attach(&RX_int_cb);
    
    while(1){
        
        if(led1 = 1)
            led1 =0;
        if(led2 = 1)
            led2 =0;
        if(led3 = 1)
            led3 =0;
        if(led4 = 1)
            led4 =0;
            
        led1 = led1 + 0.01;
        led2 = led2 + 0.01;
        led3 = led3 + 0.01;
        led4 = led4 + 0.01;
       
#ifdef EV_ALT
#if EV_ALT
#else 
        if(POWER==0)
        {
            pc.attach(NULL);
            while(Sentral_Power(0));
            pc.printf("MODULE POWER DISABLED \r\n");
            VDD_read_request();
            wait_ms(10);
            pc.printf("ENABLE POWER TO CONTINUE \r\n");
            while(!POWER);
            while(!Sentral_Power(1));
            wait_ms(10);   
            pc.attach(&RX_int_cb);
            pc.printf("MODULE POWER ENABLED\r\n");
            VDD_read_request();
        }
 #endif
 #endif       
        }

        
    //find_PROM(master, EEPROM_ADDR);
    /*
    FILE *fp = fopen("/local/TEST.hex", "r");  // Open "out.txt" on the local file system for writing  
    //hex_read_line(FILE *hexfile);
  
    while(reading)
        if(readhex)
        {
            if(feof(fp))
            {
                reading=0;
                break;
            }
            
            string input; fgets(input,2,fp);
            if(input[1] == ':')
            
            pc.printf("%X",ascii_hex2byte(input));
            
            readhex =0;
            }
    
    fclose(fp);
    pc.printf("File Closed \r\n");
    */
}

void RX_int_cb() {
    
    switch(pc.getc()) {
        
        case 'r':
        VDD_read_request();
        break;
        /*
        case 'l':
        if(reading){
            if(!hex_read_line(FILE *hexfile)){
                reading =0;
                pc.printf("EOF\r\n");}
                }else pc.printf("no file open\r\n");
        break;
        */
        case 'h':
        if(reading)
        {
            readhex = 1;
            
            }
            break;
            
        case 'f':
            find_sentral();
            break;
            
        case 's':
            pc.printf("Sentral Starting up. \r\n");
            //find_sentral();
            if(!SentralSetup(pc,master))
                //pc.printf("returning to loop\r\n");
                //else 
                pc.printf("Sentral Start exit failure\r\n");
            break;
            
        case 't':
            pc.printf("Begginng module test...\r\n");
            pc.printf("Sentral Starting up. \r\n");
            //find_sentral();
            if(!SentralSetup(pc,master))
                //pc.printf("returning to loop\r\n");
                //else 
                pc.printf("Sentral exit failure\r\n");
                
            else    if(EV0_test(pc,master)) pc.printf("Module PASS\r\n");
            
            break;
            
        default:
        pc.printf("undefined command \r\n");
        break;
        }
    
    }

void VDD_read_request() {
    
    pc.printf("Moudle Voltage: %f \r\n",(VDD_Check.read()*3.3f));
    
    }

void find_PROM(I2C i2c,int &EEPROM_ADDR) {
    
    int eeprom_success =1 ;
    
    for(EEPROM_ADDR = 0xA0;(eeprom_success && EEPROM_ADDR < 0xB0); EEPROM_ADDR+=0x02)
    {
       i2c.start();
       eeprom_success = !(master.write(EEPROM_ADDR + 0x01));
       i2c.stop();
    }
    
    if(EEPROM_ADDR < 0xB0)
        pc.printf("EEPROM found at %X \r\n", EEPROM_ADDR-2);
    else 
        pc.printf("No EEPROM found ... \r\n");
    EEPROM_ADDR -= 2;
    
    pc.printf("Testing %X, Writing '!' to 0x00 ... ", EEPROM_ADDR);
    
    
    char cmd[10];
    cmd[0] = 0x00;
    cmd[1] = 0x00;
    cmd[2] = '!';
    i2c.write(EEPROM_ADDR, cmd, 3);
 
    cmd[2] = 0;
        
    wait(0.5);
    
    i2c.write(EEPROM_ADDR, cmd, 2);
    i2c.read(EEPROM_ADDR, cmd, 1);   
        
    pc.printf("Reading Back: %c \r\n",cmd[0]) ;
    }
/*
int hex_read_line(FILE *hexfile) {
    
    char c;
    
    do{
        c = fgetc(hexfile);
    }while(!feof(hexfile) && c !=':');
    
    if(foef(hexfile)){
        pc.printf("EOF");
        return 0;
    }
    else 
    {
        string hexbyte;
        fgets(hexbyte,2,hexfile);
        ascii_hex2byte(hexbyte);
    }
    
    pc.printf("Done");
    
    }
    */
char ascii_hex2byte(char* ascii){
    
    if(ascii[1]>'Z')
        ascii[1] = ascii[1] - 'a' + 10;
    else if(ascii[1] > '9')
        ascii[1] = ascii[1] - 'A' + 10;
    else if((ascii[1] >= '0') && (ascii[1] <= '9'))
        ascii[1] = ascii[1] - '0';
    else
        pc.printf("Bad Hex Word: ascii[1]");
        
    if(ascii[0]>'Z')
        ascii[0] = ascii[1] - 'a' + 10;
    else if(ascii[0] > '9')
        ascii[0] = ascii[0] - 'A' + 10;
    else if((ascii[0] >= '0') && (ascii[1] <= '9'))
        ascii[0] = ascii[0] - '0';
    else
        pc.printf("Bad Hex Word: ascii[0]");
        
    return (ascii[0] *16 )+ ascii[1];
        
    
    }
    
void find_sentral(){
    char inbuff[2],obuff[2];
    obuff[0] = 0x37;
    int check[2];
    
    check[0] = master.write(0x50, obuff, 1);
    check[1] = master.read(0x50, inbuff, 1);
    pc.printf("finding sentral... \r\nwrite %s \r\n",check[0] ? "Fail" : "Pass" );
    
    pc.printf("read %s \r\n reading back: %X \r\n",check[1] ? "Fail" : "Pass" , inbuff[0]);
    
    if(!check[0] && !check[1]){
    pc.printf("Sentral Status: \r\n");
    pc.printf("NEEPROM:   %d \r\n", (int)((inbuff[0] & 16)>0));
    pc.printf("StbyState: %d \r\n", (int)((inbuff[0] & 8)>0));
    pc.printf("UploadErr: %d \r\n", (int)((inbuff[0] & 4)>0));
    pc.printf("UploadCPT: %d \r\n", (int)((inbuff[0] & 2)>0));
    pc.printf("EEPROMDTC: %d \r\n", (int)((inbuff[0] & 1)>0));}
    
    //pc.printf("Sentral Status: %X",cmd[0]);
}
/*
void sentral_startup()
{   
    //reset request : 50.9c.01
    
    //readback status, looking for xxxx x01x -- while((byte & 0x06) !=2)) 
    
    wait(100)
    
    }*/
//EOL
