//STM32 Tracler ports
#include "mbed.h"

#define SENTRAL_DI02

#define TRUE    1
#define FALSE   !TRUE

#include "Sentral.h"


DigitalOut SentralPower(p20);
DigitalOut SA0(p21);

int Set_SA0(int val){
    
    SA0 = (int)(val > 0);
    return SA0;   
}

int Sentral_Power(int val){
    
    SentralPower = (int)(val > 0);
    return SentralPower;
}

void Sentral_Reset(){
    
    Sentral_Power(0);
    wait(1);
    Sentral_Power(1);
    
}


//I2C master(p28, p27);
//Serial pc(USBTX,USBRX);

/*******************************************************************************
* Function Name  : SentralSetup
* Description    : code snippet for setting up sentral
*                  to run.
* Return         : None
*******************************************************************************/ 
unsigned int SentralSetup(Serial &pc,I2C &master){
  

  Sentral_Reset();
  
  unsigned char /*temp[1],*/boot_timeout=0,count=0x00;
  //unsigned char test = 0, ReturnedByte=0x00;
  //int ret_status= 0x00;  
  
  char cmd[10];
    
  
  //Serial_PutString("Sentral Reset Reg", 20);
  cmd[0] = RESET_REQ_REG;
  cmd[1]=0x01;
  int check = master.write(SENTRAL_ADDRESS,cmd,2); 
  
  cmd[0] = 0;
  
  if(check)
    pc.printf("I2C Reset Request Fail, Check pull-ups and Reset \r\n",check);
  else
    pc.printf("Reset Request Pass \r\n");
  
  pc.printf("Status Check: ");
  //while(((ReturnedByte & 0x06) != 2)&&(boot_timeout==0)){
  while(((cmd[0] & 0x06) != 2)&&(boot_timeout==0)){
    
    //test=SentralRead(SENTRAL_STATUS_REG,&ReturnedByte);
    cmd[0] = SENTRAL_STATUS_REG;
    //cmd[1]= 0x01;
    check = master.write(SENTRAL_ADDRESS, cmd, 1);
    if(check)
        pc.printf("i2c write fail %d \r\n",check);
    cmd[0] = 0;
    master.read(SENTRAL_ADDRESS, cmd, 1);
    if(check)
        pc.printf("i2c read fail %d \r\n",check);
    
    //pc.printf(" %d,%X",count,cmd[0]);
    
    count++;
    if(count==30)
      boot_timeout=1;
    
    wait_ms(100);
    
  }
  
  if(boot_timeout){
     //PrintChars("Timeout occured, sentral not present or took too long to boot from the EEPROM\n\r");
    pc.printf("Timeout occured, sentral not present or took too long to boot from the EEPROM\n\r");

     //SerialPutChars("ReturnByte: 0x");
     pc.printf("Timeout ReturnByte: %X \r\n", cmd[0]);
     //char testbuff[5];
     //snprintf(testbuff, 5, "%x,", ReturnedByte);
     //SerialPutString(testbuff,5);
     //SerialPutChars("Force it");
     //SerialPutChar('\n');
     //SerialPutChar('\r');

    return RETURN_FAILURE;
  }

    pc.printf("Success ReturnByte: %X \r\n", cmd[0]);
    // SerialPutChars("ReturnByte: 0x");
    // char testbuff[5];
    // snprintf(testbuff, 5, "%x,", ReturnedByte);
    // SerialPutString(testbuff,5);
    // //SerialPutChars("Force it");
    // SerialPutChar('\n');
    // SerialPutChar('\r');
     
      //force a times out after 3 seconds
     //count = 0;
     //boot_timeout = FALSE;
      //while(boot_timeout==FALSE){
      //count++;
      //if(count==30)
      //  boot_timeout=TRUE;
      
      wait(1);
    //}

  
  //SentralWrite(ENABLE_EVENTS_REG,0x20); // enable gyro event only (for data logging function)
  //SentralWrite(MAG_RATE_REG,0x64); //set mag rate
  //SentralWrite(ACCEL_RATE_REG,0x0a); //set accel rate
  //SentralWrite(GYRO_RATE_REG,0x46); //set gyro rate
  //SentralWrite(ALGORITHM_CONTROL,0x02); //update registers with RAW sensor data
  //SentralWrite(ALGORITHM_CONTROL,0x00); //update registers with Scaled sensor data
  
  //SentralWrite(HOST_CONTROL_REG,0x01); //Request CPU to run 
  cmd[0] = HOST_CONTROL_REG;
  cmd[1]=0x01;
  master.write(SENTRAL_ADDRESS,cmd,2); 
  pc.printf("Sentral Startup Success. \r\n");
  
  return 1;
}