#include "mbed.h"
#include "Test_Routines.h"

BusIn GPIOS(p10,p11,p12,p13,p14,/*p15*/p9,p16);
Timeout escape;

int timeout=0;

void timeit()
{
    timeout =1;
    }
    
int EV0_test(Serial &pc,I2C &master)
{
    
    int trig;int P;
    pc.printf("Waiting for a pin to trigger...            ");
   do
    {
        P = GPIOS;
        
        if(P&&0x40)
            trig = 6;
        if(P&&0x01)
            trig = 0;
        if(P&&0x02)
            trig = 1;
        if(P&&0x04)
            trig = 2;
        if(P&&0x08)
            trig = 3;
        if(P&&0x10)
            trig = 4;
        if(P&&0x20)
            trig = 5;
        } while((!(GPIOS) && (timeout < 1000)));
        
    if(timeout < 1000)
        pc.printf("Trigger: Pin%d \r\n",trig);
    else
        pc.printf("No Trigger\r\n");
    timeout=0;
    while( ( GPIOS < 0x7F ) && (timeout < 1000) )
        timeout++;
    if(timeout < 100)
        pc.printf("Notice: Pins are simultaneous, check continuity \r\n");
    
    timeout=0;
    
    escape.attach(&timeit, 10.0);
    
    while(!(GPIOS&&0x40))//6
        if(timeout) break;
    while(!(GPIOS&&0x01))//0
        if(timeout) break;
    while(!(GPIOS&&0x02))//1
        if(timeout) break;
    while(!(GPIOS&&0x04))//2
        if(timeout) break;
    while(!(GPIOS&&0x08))//3
        if(timeout) break;
    while(!(GPIOS&&0x10))//4
        if(timeout) break;
    while(!(GPIOS&&0x20))//5
        if(timeout) break;
        
    if(!timeout){
        pc.printf("All Pins Fired\r\n");
        return 1;
        }
    else
        pc.printf("GPIO Timeout, Test FAILED");
        
    return 0;
    
    
}

//EOF

