/* Sharp Sensor Test
 * Connections:
 * PIN15          (White) Signal
 * 5.0V USB Out   Sensor Power (+)
 * GND            Sensor Gnd   (-)
 * Place a 10uf cap close the the sensor between VCC nad GND
 */
#include "mbed.h"

/* Standard LED's on the mbed */
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

/* Our signal line is PIN15 */
AnalogIn   Sensor(p15);

int main() {
    while (1) {
        /*
         * Efficient way as the object gets closer to the
         * sensor the LED's will turn on, as the object
         * moves away they count back down. Original by Dan Ros
        */
        led1 = (Sensor > 0.2) ? 1 : 0;
        led2 = (Sensor > 0.4) ? 1 : 0;
        led3 = (Sensor > 0.6) ? 1 : 0;
        led4 = (Sensor > 0.8) ? 1 : 0;

        /*
         * A cool effect when the full range of the sensor
         * has been reached, all LED's flash
        */
        if (Sensor  >= 0.9) {
            led1 = led2 = led3 = led4 = 1;
            wait(0.02);
            led1 = led2 = led3 = led4 = 0;
            wait(0.02);
        }

        wait(0.02);

    }
}
