//-----------------------------------------------NEW BP code starts--------------------------------///



#include "mbed.h"
#include "MAX30102.h" // BP ADD
#include <string.h>
#include <stdio.h>

#include <time.h>
//#include <iostream>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "bp.h"
#include "display_modules.h"



#include "struct.h"
//#include "test_type.h"

using namespace std;

Serial bpr(USBTX,USBRX);
DigitalIn INTR(PTC7);

Timer t; 


//FILE *ecg;
//FILE *ppg;
    
 void bp(int32_t pid) {
    
    uint8_t uch_dummy;
    uint32_t ppgdata; 
    uint8_t lead_reg=0;
    //int dummyconcat = 700000;
    int concatenate_value2 = 0;
    unsigned char chk = 1;

    uint32_t drum11[64];
    uint32_t drum21[64];
    
           
    //Declaration of  Master structure
    
    BLEMsg_info *ptr_BLEMsg_info_bp, BLEMsg_info_bp; // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_bp" is created
    ptr_BLEMsg_info_bp = &BLEMsg_info_bp;            // *ptr_BLEMsg_info_bp is the pointer to local copy;
    
    // Declaration of Date Structure
    DateTime_info *ptr_DateTime_info_bp, DateTime_info_bp; // A copy of Master Structure "DateTime_info" created, 
    ptr_DateTime_info_bp = &DateTime_info_bp;             // Structure pointer points to that copy.
    
    
    // RTC operations
    time_t epoch_time_bp;           //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_bp = rtc_read();    // time is got from get epoch function.  
    
    struct tm * ptr_time_info_bp, time_info_bp;   // Sturucture copy of tm is created
    ptr_time_info_bp = localtime(&epoch_time_bp); // Structure accepts the time in local format from "time_t" type.
      
    //BELOW LINE IS TO CHECK Date and TIME 
    bpr.printf("Time is %d: %d: %d\n", (*ptr_time_info_bp).tm_hour, (*ptr_time_info_bp).tm_min, (*ptr_time_info_bp).tm_sec);
    bpr.printf("Date is %d:%d:%d\n", (*ptr_time_info_bp).tm_mday, (*ptr_time_info_bp).tm_mon+1, (*ptr_time_info_bp).tm_year-100);
    
    //Copying from one structure to the other using variables
    DateTime_info_bp.hour = (uint8_t)(*ptr_time_info_bp).tm_hour;
    DateTime_info_bp.mins = (uint8_t)(*ptr_time_info_bp).tm_min;
    DateTime_info_bp.sec =  (uint8_t)(*ptr_time_info_bp).tm_sec;
    
    DateTime_info_bp.date = (uint8_t) (*ptr_time_info_bp).tm_mday;
    DateTime_info_bp.month =(uint8_t)(*ptr_time_info_bp).tm_mon+1;
    DateTime_info_bp.year = (uint8_t)(*ptr_time_info_bp).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_bp.date_time.hour = DateTime_info_bp.hour;
    BLEMsg_info_bp.date_time.mins = DateTime_info_bp.mins;
    BLEMsg_info_bp.date_time.sec = DateTime_info_bp.sec;
    
    BLEMsg_info_bp.date_time.date = DateTime_info_bp.date ;
    BLEMsg_info_bp.date_time.month = DateTime_info_bp.month ;
    BLEMsg_info_bp.date_time.year =  DateTime_info_bp.year ;
    
    
    //Checking if the structure has these values    
    bpr.printf("Time 2 is %d:%d:%d\n", DateTime_info_bp.hour, DateTime_info_bp.mins, DateTime_info_bp.sec);
    bpr.printf("\t Date is %d:%d:%d\n",DateTime_info_bp.date, DateTime_info_bp.month, DateTime_info_bp.year);
    
    
    //Loading values to of Test type
    test_type_info test_type_info_bp;  // copy of " test_type_info" created  
    test_type_info_bp = BP_Test;       // Loaded value 00 to the test type 
    
    BLEMsg_info_bp.test_type = test_type_info_bp;
    //Check if 00 is getting printed
    bpr.printf("Test Type is : %d\n", test_type_info_bp);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_bp.device_id = 01;                   // Device ID fixed
    BLEMsg_info_bp.patient_id = (uint32_t)pid;       // Patient ID
    BLEMsg_info_bp.sampling_freq = 500;              // sampling frrquency
    BLEMsg_info_bp.length = 10774;                   //Total length of data in bytes  22 B+10752 B
    
    /*
    //Loading number of samples
    NumSamples_info NumSamples_info_bp;              //Copy of structure NumSamples_info
    NumSamples_info_bp.num_ppg_sample = 1664;        // PPG & ECG Sample number loaded in structure copy
    NumSamples_info_bp.num_ecg_sample = 1024;
    */
    
    BLEMsg_info_bp.num_samples.num_sample_ppg_dummy =  1664 ;// PPG  number of samples copied to master struct 
    BLEMsg_info_bp.num_samples.num_sample_ecg_OTtyp =  1024 ; // ECG  number of samples copied to master struct
    
    
      
    

    // Variables for file operations
   // uint32_t amax=0;
    //uint32_t bmax = 0;
    //uint32_t a;
    //uint32_t b;
    
   //int aloc = 0;
   //int bloc = 0;
   //int samples = 0;

    bpr.baud(baud_rate);

    freqset();               // setting the frequency
    setupfunc();              
    lead_reg=ecgsetupfunc();    // lead contact // 14/06
        
    maxim_max30102_reset();  // PPG reset
    wait_ms(20);
    maxim_max30102_init();
        
    chk = 1;
        
    wait(2);
    //bc.printf("BP start\n");  

    for(int i=0; i<500; i++)
    {
        
        concatenate_value2= readvalue();
        
        maxim_max30102_read_reg(0,&uch_dummy);
        while(INTR.read()==1); 
        maxim_max30102_read_fifo(&ppgdata); 
            
    }   
// BP Finger detect Function Added Nidhin 16/6/17 
// START    
 uint32_t un_max, un_min; // Declare two VARIABLE FOR MAX AND MIN
 un_max = 0;
un_min = 0x3FFF;
       
for(int i=0; i<500; i++)    // READS 500 SAMPLES TO SEE MAX AND MIN VAL DIFFERENCE
{        
maxim_max30102_read_reg(0,&uch_dummy);
while(INTR.read()==1); 
maxim_max30102_read_fifo(&ppgdata); 
bpr.printf("%d\n",ppgdata);
if(un_min>ppgdata)
un_min=ppgdata;    //update signal min
if(un_max<ppgdata)
un_max=ppgdata; 

}  

bpr.printf("The max is %d\n", un_max); //
bpr.printf("The min is %d\n", un_min);
if (((un_max -un_min) > 300) && (lead_reg==0)) // Checking for threshold 300 Added Nidhin 16/6/17

{ //Added Nidhin 16/6/17

    sd_open_BPfilee(pid);
    sd_open_BP_ECGfile(pid) ; //   sd_open_BP_ECGfile(123) draft file for testing
    sd_open_BP_PPGfile(pid) ; // sd_open_BP_PPGfile(123) draft file for testing

    FILE *ecg = NULL;
    FILE *ppg = NULL;
    uint32_t *drum_ecg = NULL; // pointers to ecg buffer  changed to uint32_t from int
    uint32_t *drum_ppg = NULL; // pointer to ppg buffer
    
    drum_ecg = drum11;
    drum_ppg = drum21;
    
    for(int j =0 ; j<1; j++) // changed to 16 from 8 // Change by Nidhin 30/5/2017 Direct writing to SD card. no loop required
    {
        for(int i=0; i<1024; i++)
        {
            concatenate_value2 = readvalue();
            //drum11[i]=(uint32_t)concatenate_value2;   //drum11[i]=concatenate_value2;      drum11[i]=dummyconcat; typecasted to uint32_t
            //Change by Nidhin 30/5/2017 Direct writing to SD card.
            ecg = sd_BP_ecgwrite(&concatenate_value2);
            
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            ppg = sd_BP_ppgwrite(&ppgdata); //Change by Nidhin 30/5/2017 Direct writing to SD card.
            //drum21[i]=ppgdata;            //Change by Nidhin 30/5/2017 Direct writing to SD card.
        }
                           
            //ecg = sd_BP_ecgwrite(drum_ecg); // //Change by Nidhin 30/5/2017 Direct writing to SD card.
            //ppg = sd_BP_ppgwrite(drum_ppg); // //Change by Nidhin 30/5/2017 Direct writing to SD card.
        
        
    } 
    
    for(int j =0 ; j<1; j++) // changed to 16 from 8
    {
        for(int i=0; i<640; i++)
        {
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            //drum21[i]=ppgdata; 
            ppg = sd_BP_ppgwrite (&ppgdata);         //Change by Nidhin 30/5/2017 Direct writing to SD card.
        }
        
         
        
     }  
    fclose(ecg);
    fclose(ppg);
     
    maxim_max30102_reset();
    
    //-----Reading from file starts //
    
    //std::ifstream ec1("/sd/123_BP_ECG.csv");
    //std::ifstream pp1("/sd/123_BP_PPG.csv");
    
    int eloc = 0;
    int ploc = 0;
   
   
   eloc = sd_BP_ECGMAX(pid); // eloc = sd_BP_ECGMAX(123);
   ploc = sd_BP_PPGMAX(pid); // ploc = sd_BP_PPGMAX(123);
    
   //bc.printf("The ECG max is at : %d", eloc);
   //bc.printf("The PPG Max is at : %d", ploc);
   
   float PWV = 0;
   int d = 210000;
   int delta_t = 0;
   float SBP = 0;
   float DBP = 0;
   
   delta_t  = (2*(ploc - eloc));
   PWV = d/delta_t;
   
    SBP = 0.0508955*PWV+62.559;
    DBP = (0.0494*PWV + 17.480)+10;
    
    /*
    //Copying to Structure starts
    CalData_info CalData_info_bp;
    CalData_info_bp.cal_sbp = (uint16_t) SBP;
    CalData_info_bp.cal_dbp = (uint16_t) DBP; NOT REQUIRED
    */
    
    BLEMsg_info_bp.cal_data.cal_sbp_dummy = (uint16_t) SBP;
    BLEMsg_info_bp.cal_data.cal_dbp_OTtyp = (uint16_t) DBP;
    
     if((SBP>190 || SBP<70)  && (DBP>100 || DBP<40))              // checking for range below and above and then displaying error
   {
        screen_bp_error();             // checking for error out of range- nikita 10-7-17
     
       } 
    
    else 
    { 
    
        create_single_BPfile(pid);                          // Copy ECG and PPG data to BP file
        structure_file(ptr_BLEMsg_info_bp, pid);            // Copy BP structure to main file
         bpfile_mainfile(pid);
    
         screen_bp1(SBP,DBP);
      }
  }  //Added Nidhin 16/6/17  
  
  else  //Added Nidhin 16/6/17 
  {     //Added Nidhin 16/6/17 
    // Add display sequence for Finger detect fail  //Added Nidhin 16/6/17 
    maxim_max30102_reset();
    bpr.printf("no finger detect\n");
      screen_ecg_lead_bp_fingerdetect();
  }  //Added Nidhin 16/6/17 
     screen_ecg_bp() ; 
    // Only for testing
 //} //Commented Nidhin 16/6/17 
} 