
#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"

#define  T_START 1392096720 //RTC time = Mon, 10 Feb 2014 21:32:00 PDT

#define JOY_UP    p16 // joystick related pins
#define JOY_DOWN  p13
#define JOY_LEFT  p12
#define JOY_RIGHT p15

BusIn nibble(p12, p13, p14, p15);

void upDateLCD(C12832_LCD *lcd, float mycurrentTemp, time_t *mycurrentTime)
{
    (*lcd).cls();
    (*lcd).locate(0,0);
    (*lcd).printf("Temp: %.2f\n", mycurrentTemp);
    //(*lcd).printf("Time: %s", ctime(mycurrentTime)); // don't use this one
    char buffer[20];  // strftime format begets .e.g. "May 19 03:10:50 PM"
    strftime(buffer, 20, "%b %d %I:%M:%S %p\n",localtime(mycurrentTime));//note pointer
    (*lcd).printf("%s", buffer);
}

void upDateTerminal(Serial *pc, float mycurrentTemp, time_t *mycurrentTime, int myJoyVal)
{
    (*pc).printf("myJoyVal = %d\n", myJoyVal);
    (*pc).printf("Current Temp: %.2f\n", mycurrentTemp);
    (*pc).printf("Time as seconds since January 1, 1970 = %d\n", *mycurrentTime);
    (*pc).printf("Time as a basic string = %s", ctime(mycurrentTime));//note pointer
    char buffer[20]; // strftime() format begets .e.g. "May 19 03:10:50 PM"
    strftime(buffer, 20, "%b %d %I:%M:%S %p\n", localtime(mycurrentTime));//note pointer
    (*pc).printf("Time as a custom formatted string = %s\n", buffer);
}

void getMyTempnTime(LM75B *mytmpSns, float *mycurrentTemp, time_t *mycurrentTime)
{
    *mycurrentTemp = (((*mytmpSns).read()*9/5)+32);
    *mycurrentTime = time(NULL);
}


void readJoyStick(BusIn *myJoyStick, int *myJoyVal)
{
    int sampleJoyVal = *myJoyStick;
    wait(.04);
    if (sampleJoyVal != *myJoyStick) // if not stable, clear sample
    {
        *myJoyVal = 0;
    }
    else
    {
        switch (sampleJoyVal) //disallow "diagonal" combinations
        {
            case 0x1: // JOY_RIGHT
            case 0x2: // JOY_LEFT
            case 0x4: // JOY_DOWN
            case 0x8: // JOY_UP
                (*myJoyVal) = sampleJoyVal; 
                break;
            default:  (*myJoyVal) = 0; // JOY_IDLE
                break;
        }
    }
}

/*******************************************************************
* EXPERIMENT_F_CALL.CPP
* Date: 2/17/2014  Author: George (Michael) Hey
* MBED Program to read time and temperature periodically (~ every second)
* and also to read the joystick, debounced.
* Displays to the LCD screen temperature and time.
* Displays to the PC terminal the joystick value, temperature and time.
* Reference http://mbed.org/handbook/Time?action=view&revision=11592
* http://mbed.org/users/petereiso/notebook/cc-time-functions/
* This program puts all the peripherals inside main(), and passes
* peripheral pointers to functions().
*******************************************************************/
int main()
{
    C12832_LCD lcd;
    LM75B tmpSns(p28,p27);
    Serial pc(USBTX, USBRX); // tx, rx
    float currentTemp = 0;
    time_t currentTime = T_START;  // see #define
    BusIn joyStick(JOY_UP,JOY_DOWN,JOY_LEFT,JOY_RIGHT);
    int joyVal = 28; // bogus value for debug

    set_time(T_START); //  RTC start time - see #define
    while (1) {
        time_t seconds = time(NULL);
        getMyTempnTime(&tmpSns, &currentTemp, &currentTime);
        readJoyStick(&joyStick, &joyVal);
        upDateLCD(&lcd, currentTemp, &currentTime);
        upDateTerminal(&pc, currentTemp, &currentTime, joyVal);
        wait(1.0);
    }
    return 0;
}
